/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.gui;

import java.util.ArrayList;
import java.util.List;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class TreeRegistryModel implements TreeModel {

	private final String root = "services";
	private final String esbServices = "ESB Web Services";
	private final String partnerWebServices = "Partner Web Services";
	private Registry registry = null;


	private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();

	public TreeRegistryModel(Registry r) throws SOAPException {
		this.registry = r;
	}

	public Object getRoot() {
		return this.root;
	}

	public Object getChild(final Object parent, final int index) {
		Object res = null;
		if(parent == this.getRoot()) {
				if(index == 0) {
					res = this.esbServices;
				} else {
					res = this.partnerWebServices;
				}
		} else if(parent == esbServices) {
			res = this.registry.getAllNodes().get(index);;
		} else if(parent == partnerWebServices) {
			res = this.registry.getWebServices().get(index);
		} else if(parent instanceof MockService) {
			res = ((MockService)parent).getEndpoints().get(index);
		} else if(parent instanceof MockEndpoint) {
			res = ((MockEndpoint)parent).getBinding();
		} else if(parent instanceof MockBinding) {
			res = ((MockBinding)parent).getOperations().get(index);
		} else if(parent instanceof Node) {
			res = ((Node)parent).getClientEndpointProxies().get(index).getService();
		} 
		return res;
	}

	public int getChildCount(final Object parent) {
		int res = 0;
		if(parent == this.getRoot()) {
			res = 2;
		} else if(parent == esbServices) {
			res = this.registry.getAllNodes().size();
		} else if(parent == partnerWebServices) {
			res = this.registry.getWebServices().size();
		} else if(parent instanceof MockService) {
			res = ((MockService)parent).getEndpoints().size();
		} else if(parent instanceof MockEndpoint) {
			res = 1;
		} else if(parent instanceof MockBinding) {
			res = ((MockBinding)parent).getOperations().size();
		} else if(parent instanceof Node) {
			res = ((Node)parent).getClientEndpointProxies().size();
		} 
		return res;
	}

	public boolean isLeaf(final Object node) {
		boolean res = true;
		if(node == this.getRoot()) {
			res = false;
		} else if(node == esbServices && this.registry.getAllNodes().size() > 0) {
			res = false;
		} else if(node == partnerWebServices && this.registry.getWebServices().size() > 0) {
			res = false;
		} else if((node instanceof MockService)&&(((MockService)node).getEndpoints().size() > 0)) {
			res = false;
		} else if((node instanceof MockEndpoint)&&(((MockEndpoint)node).getBinding() != null)) {
			res = false;
		} else if((node instanceof MockBinding)&&(((MockBinding)node).getOperations().size() > 0)) {
			res = false;
		} else if(node instanceof Node && ((Node)node).getClientEndpointProxies().size() > 0) {
			res = false;
		} 
		return res;
	}

	public void valueForPathChanged(final TreePath path, final Object newValue) {

	}

	public int getIndexOfChild(final Object parent, final Object child) {
		int res = 0;
		if(parent == this.getRoot()) {
			if(child == this.esbServices) {
				res = 0;
			} else {
				res = 1;
			}
		} else if(parent == esbServices) {
			res = this.registry.getAllNodes().indexOf(child);;
		} else if(parent == partnerWebServices) {
			res = this.registry.getWebServices().indexOf(child);
		} else if(parent instanceof MockService) {
			res = ((MockService)parent).getEndpoints().indexOf(child);
		} else if(parent instanceof MockEndpoint) {
			res = 1;
		} else if(parent instanceof MockBinding) {
			res = ((MockBinding)parent).getOperations().indexOf(child);
		} else if(parent instanceof Node) {
			res = ((Node)parent).getClientEndpointProxies().indexOf(child);
		} 
		return res;
	}

	@SuppressWarnings("unchecked")
	public void addTreeModelListener(final TreeModelListener l) {
		this.treeModelListeners.add(l);
	}

	public void removeTreeModelListener(final TreeModelListener l) {
		this.treeModelListeners.remove(l);
	}

}
