package org.petalslink.easiestdemo.client.topology;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;

/**
 * The Ball class creates 5 balls.  Each ball increasingly blends
 * the color white with the specified color.
 */
public class LineEsbToEsbG {

	private Line2D line = null;

	protected int size;
	protected Color color;
 
	private EsbG internal;
	private EsbG external;
	
	
	public LineEsbToEsbG(EsbG internal, EsbG external) {
		this.color = Color.blue;
		this.internal = internal;
		this.external = external;
		this.line = new Line2D.Double(internal.getCenterX(), internal.getCenterY(), external.getCenterX(), external.getCenterY());
	}


	public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;

		g2.setStroke(new BasicStroke(25.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND)); // Select the line style to use
		g2.setColor(this.color);
		g2.draw(this.line);
		g2.fill(this.line);
	}

	public boolean contains(int x, int y) {
		return this.line.contains(x, y);
	}

	public void setLocation(int x1, int y1, int x2, int y2) {
		this.line.setLine(x1, y1, x2, y2);
	}
}  

