/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.menu.action.NodeListModel;

public class ConnectMonitoring2EsbFrame
extends JFrame {
    private WSOUIClient client;
    private Registry registry;
    private EsbG monitoring = null;
    private Node selectedNode = null;
    private JButton jButtonOK;
    private JLabel jLabelBSM;
    private JLabel jLabelConnect;
    private JLabel jLabelESB;
    private JLabel jLabelTo;
    private JList jListNodes;
    private JPanel jPanelMain;
    private JScrollPane jScrollPaneNode;

    public ConnectMonitoring2EsbFrame(WSOUIClient client, EsbG monitoring) {
        this.initComponents();
        this.setTitle("Connect " + monitoring.getQName().getLocalPart() + " to:");
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.monitoring = monitoring;
        this.client = client;
        this.registry = client.getRegistry();
        this.jListNodes.setModel(new NodeListModel(this.registry.getEsbNodes()));
        this.jLabelBSM.setText("Connect monitoring node  \"" + monitoring.getQName().getLocalPart() + "\" to:");
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelConnect = new JLabel();
        this.jScrollPaneNode = new JScrollPane();
        this.jListNodes = new JList();
        this.jButtonOK = new JButton();
        this.jLabelTo = new JLabel();
        this.jLabelESB = new JLabel();
        this.jLabelBSM = new JLabel();
        this.jLabelConnect.setText("Connect to node:");
        this.jListNodes.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListNodes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConnectMonitoring2EsbFrame.this.jListNodesMouseClicked(evt);
            }
        });
        this.jScrollPaneNode.setViewportView(this.jListNodes);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectMonitoring2EsbFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelTo.setText("to:");
        this.jLabelBSM.setText("connect bsm");
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup().addComponent(this.jScrollPaneNode, -2, 250, -2).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 175, Short.MAX_VALUE).addComponent(this.jButtonOK)).addGroup(jPanelMainLayout.createSequentialGroup().addGap(39, 39, 39).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelESB, -1, 173, Short.MAX_VALUE)).addComponent(this.jLabelTo))).addGroup(jPanelMainLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabelBSM, -1, 204, Short.MAX_VALUE)))).addComponent(this.jLabelConnect)).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonOK).addGroup(GroupLayout.Alignment.LEADING, jPanelMainLayout.createSequentialGroup().addComponent(this.jLabelConnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneNode, -1, 372, Short.MAX_VALUE)))).addGroup(jPanelMainLayout.createSequentialGroup().addGap(104, 104, 104).addComponent(this.jLabelBSM).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelTo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelESB, -2, 18, -2))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.registry.connectMonitoringToEsb(this.monitoring.getModel(), this.selectedNode);
            this.client.refreshAll();
            this.setVisible(false);
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Connect monitoring node Interrupted", 0);
        }
    }

    private void jListNodesMouseClicked(MouseEvent evt) {
        this.selectedNode = (Node)this.jListNodes.getSelectedValue();
        this.jLabelESB.setText(this.selectedNode.getQName().getLocalPart());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ConnectMonitoring2EsbFrame(null, null).setVisible(true);
            }
        });
    }
}

