/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.notification;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Calendar;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.notification.NotifyGui;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterFrame
extends JFrame {
    private JLabel jLabelFilter;
    private JLabel jLabelIdentification;
    private JPanel jPanelMain;
    private JScrollPane jScrollPaneText;
    private JTextArea jTextArea;

    public FilterFrame(WSOUIClient client, NotifyGui notifyGui) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.setTitle("Filter notification");
        if (notifyGui != null && notifyGui.getNotify() != null && notifyGui.getNotify().getNotificationMessage() != null && notifyGui.getNotify().getNotificationMessage().size() > 0) {
            EJaxbNotificationMessageHolderType nmht = (EJaxbNotificationMessageHolderType)notifyGui.getNotify().getNotificationMessage().get(0);
            Element elmt = (Element)nmht.getMessage().getAny();
            try {
                if (elmt.getLocalName().equals("OperationMetrics")) {
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.importNode(elmt, true));
                    OperationMetrics op = (OperationMetrics)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(doc, OperationMetrics.class);
                    String msg = "";
                    msg = msg + "Operation name: " + QName.valueOf(op.getOperationName()).getLocalPart() + "\n";
                    msg = msg + "Interface name: " + op.getPortType() + "\n";
                    msg = msg + "Metrics: " + "\n";
                    msg = msg + "\tAverage latency:               " + op.getServiceTime().getDuration().getTimeInMillis(Calendar.getInstance()) + "\n";
                    msg = msg + "\tLast response time:            " + op.getLastResponseTime().getDuration().getTimeInMillis(Calendar.getInstance()) + "\n";
                    msg = msg + "\tMaximum response time:         " + op.getMaxResponseTime().getDuration().getTimeInMillis(Calendar.getInstance()) + "\n";
                    msg = msg + "\tNumber of requests:            " + op.getNumberOfRequests().getValue() + "\n";
                    msg = msg + "\tNumber of successful requests: " + op.getNumberOfSuccessfulRequests().getValue() + "\n";
                    msg = msg + "\tNumber of failed requests:     " + op.getNumberOfFailedRequests().getValue() + "\n";
                    msg = msg + "\tLast request size:             " + op.getLastRequestSize().getValue() + "\n";
                    msg = msg + "\tMaximum request size:          " + op.getMaxRequestSize().getValue() + "\n";
                    msg = msg + "\tLast response size:            " + op.getLastResponseSize().getValue() + "\n";
                    msg = msg + "\tMaximum response size:         " + op.getMaxResponseSize().getValue() + "\n";
                    this.jTextArea.setText(msg);
                    this.jLabelIdentification.setText("Notification identified as WSDM operation metric");
                }
            }
            catch (ParserConfigurationException e) {
                this.jLabelIdentification.setText("Notification not identified");
                this.jTextArea.setText(e.getMessage());
            }
            catch (XmlObjectReadException e) {
                this.jLabelIdentification.setText("Notification not identified");
                this.jTextArea.setText(e.getMessage());
            }
        }
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelFilter = new JLabel();
        this.jLabelIdentification = new JLabel();
        this.jScrollPaneText = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jLabelFilter.setText("Filter:");
        this.jTextArea.setColumns(20);
        this.jTextArea.setRows(5);
        this.jScrollPaneText.setViewportView(this.jTextArea);
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 562, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneText, -1, 542, Short.MAX_VALUE).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jLabelFilter).addGap(18, 18, 18).addComponent(this.jLabelIdentification, -1, 496, Short.MAX_VALUE))).addContainerGap())));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 377, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelFilter).addComponent(this.jLabelIdentification, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPaneText, -2, 330, -2).addContainerGap(-1, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FilterFrame(null, null).setVisible(true);
            }
        });
    }
}

