/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.gui;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;

public class TreeRegistryModel
implements TreeModel {
    private final String root = "services";
    private final String esbServices = "ESB Web Services";
    private final String partnerWebServices = "Partner Web Services";
    private Registry registry = null;
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();

    public TreeRegistryModel(Registry r) throws SOAPException {
        this.registry = r;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object res = null;
        if (parent == this.getRoot()) {
            res = index == 0 ? this.esbServices : this.partnerWebServices;
        } else if (parent == "ESB Web Services") {
            res = this.registry.getAllNodes().get(index);
        } else if (parent == "Partner Web Services") {
            res = this.registry.getWebServices().get(index);
        } else if (parent instanceof MockService) {
            res = ((MockService)parent).getEndpoints().get(index);
        } else if (parent instanceof MockEndpoint) {
            res = ((MockEndpoint)parent).getBinding();
        } else if (parent instanceof MockBinding) {
            res = ((MockBinding)parent).getOperations().get(index);
        } else if (parent instanceof Node) {
            res = ((Node)parent).getClientEndpointProxies().get(index).getService();
        }
        return res;
    }

    @Override
    public int getChildCount(Object parent) {
        int res = 0;
        if (parent == this.getRoot()) {
            res = 2;
        } else if (parent == "ESB Web Services") {
            res = this.registry.getAllNodes().size();
        } else if (parent == "Partner Web Services") {
            res = this.registry.getWebServices().size();
        } else if (parent instanceof MockService) {
            res = ((MockService)parent).getEndpoints().size();
        } else if (parent instanceof MockEndpoint) {
            res = 1;
        } else if (parent instanceof MockBinding) {
            res = ((MockBinding)parent).getOperations().size();
        } else if (parent instanceof Node) {
            res = ((Node)parent).getClientEndpointProxies().size();
        }
        return res;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean res = true;
        if (node == this.getRoot()) {
            res = false;
        } else if (node == "ESB Web Services" && this.registry.getAllNodes().size() > 0) {
            res = false;
        } else if (node == "Partner Web Services" && this.registry.getWebServices().size() > 0) {
            res = false;
        } else if (node instanceof MockService && ((MockService)node).getEndpoints().size() > 0) {
            res = false;
        } else if (node instanceof MockEndpoint && ((MockEndpoint)node).getBinding() != null) {
            res = false;
        } else if (node instanceof MockBinding && ((MockBinding)node).getOperations().size() > 0) {
            res = false;
        } else if (node instanceof Node && ((Node)node).getClientEndpointProxies().size() > 0) {
            res = false;
        }
        return res;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int res = 0;
        if (parent == this.getRoot()) {
            res = child == this.esbServices ? 0 : 1;
        } else if (parent == "ESB Web Services") {
            res = this.registry.getAllNodes().indexOf(child);
        } else if (parent == "Partner Web Services") {
            res = this.registry.getWebServices().indexOf(child);
        } else if (parent instanceof MockService) {
            res = ((MockService)parent).getEndpoints().indexOf(child);
        } else if (parent instanceof MockEndpoint) {
            res = 1;
        } else if (parent instanceof MockBinding) {
            res = ((MockBinding)parent).getOperations().indexOf(child);
        } else if (parent instanceof Node) {
            res = ((Node)parent).getClientEndpointProxies().indexOf(child);
        }
        return res;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }
}

