/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiestdemo.helper;

import com.ebmwebsourcing.easierbsm.BSMFactoryImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbBpelReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public final class BusManagement {
    private static BusManagement BusManagement = new BusManagement();
    private ESBFactory esbFactory = null;
    private ESBFactory monitoringFactory = null;

    public static BusManagement getInstance() {
        return BusManagement;
    }

    private BusManagement() {
    }

    public void setESBFactory(ESBFactory factory) {
        this.esbFactory = factory;
    }

    public ESBFactory getESBFactory() {
        if (this.esbFactory == null) {
            this.esbFactory = new ESBFactoryImpl(new String[]{"data-collector-factory", "wsdm-monitoring-factory", "sla-manager-factory"});
        }
        return this.esbFactory;
    }

    public void setMonitoringFactory(ESBFactory factory) {
        this.monitoringFactory = factory;
    }

    public ESBFactory getMonitoringFactory() {
        if (this.monitoringFactory == null) {
            this.monitoringFactory = new BSMFactoryImpl(new String[]{"creation-resources-service-factory", "rawreport-service-factory"});
        }
        return this.monitoringFactory;
    }

    public Node createBSMNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactory factory = this.getMonitoringFactory();
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    public Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactory factory = this.getESBFactory();
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    public List<URL> deployAndExposeBPEL(URL bpel, URL nodeUrl) throws ManagementException {
        ArrayList<URL> res = new ArrayList<URL>();
        try {
            EJaxbDeploy payload = new EJaxbDeploy();
            EJaxbDescriptorType main = new EJaxbDescriptorType();
            main.setFileURI(bpel.toString());
            payload.setMainResource(main);
            UserManagementClientSOAP client = new UserManagementClientSOAP(nodeUrl.toString());
            EJaxbDeployResponse response = client.deploy(payload);
            EJaxbBpelReport report = (EJaxbBpelReport)response.getDeployementReport().getAny();
            for (String url : report.getExternalEndpointsAddressesCreated()) {
                res.add(new URL(url));
            }
        }
        catch (MalformedURLException e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        return res;
    }
}

