package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map.Entry;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Annotation;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Method;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Parameter;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.util.logging.Level;
import java.util.logging.Logger;


public class ImplementationManagerGenerator {

    private ImplMetaInf imf;
    private String tns;

    public ImplementationManagerGenerator(String tns, ImplMetaInf imf) throws WSOUIException {
        this.imf = imf;
        this.tns = tns;
    }




    private String generateImplementationMethod(Method m, String basedir) {
        String res = "";
        res = "";
        res = res + "\t\t" + Parameter.findType(m.getOutputParam().getType()) + " response = null;\n";
        res = res + "\t\teventProducer.sendEventBeforeProcessingRequest(\"" + m.getName() + "\" ," + Method.generateListOfInputParameterNames(m) + ");\n";
        if(!m.getOutputParam().getType().equals("void")) {
            res = res + "\t\tresponse = this.getTestImplementation()." + m.getName() + "(" + Method.generateListOfInputParameterNames(m) + ");\n" ;
        } else {
            res = res + "\t\tthis.getTestImplementation()." + m.getName() + "(" + Method.generateListOfInputParameterNames(m) + ");\n" ;
        }

        // generate automatically the subscription if we detect that is the ws subsription method
        if(m.getInputParams().size() == 1 && m.getOutputParam().getType().equals("com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse")) {
            res = res + ""
                    + "\t\tif(response == null) {\n"
                    + "\t\t\ttry {\n"
                    + "\t\t\t\tresponse = eventProducer.getSubscriptionManager().subscribe(" + Method.generateListOfInputParameterNames(m) + ");\n" 
                    + "\t\t\t} catch (WsnbException e) {\n"
                    + "\t\t\t\tthrow new org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault(e.getMessage(), e);\n"
                    + "\t\t\t}\n"
                    + "\t\t}\n";
        } else if(m.getOutputParam() != null && m.getOutputParam().getType().equals("com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse")) {
            res = res + ""
                    + "\t\tif(response == null) {\n"
                    + "\t\t\tif(getResourcePropertyRequest == null) {\n"
                    + "\t\t\t\tthrow new org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault(\"Property cannot be null\");\n"
                    + "\t\t\t}\n"
                    + "\t\t\tif(getResourcePropertyRequest.getLocalPart().equals(\"TopicSet\")) {\n"
                    + "\t\t\t\tDocument topicSetDoc = eventProducer.getSubscriptionManager().getTopicSetDocument();\n"
                    + "\t\t\t\tresponse = new com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse();\n"
                    + "\t\t\t\tif(topicSetDoc != null) {\n"
                    + "\t\t\t\t\tresponse.getAny().add(topicSetDoc.getDocumentElement());\n"
                    + "\t\t\t\t}\n"
                    + "\t\t\t} else {\n"
                    + "\t\t\t\tthrow new org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault(getResourcePropertyRequest.getLocalPart() + \" property unknown\");\n"
                    + "\t\t\t}\n"
                    + "\t\t}\n";
        }
        res = res + "\t\tif(this.isActivateGUI()) {\n"
                + "\t\t  this.getGuiImplementation().setExchangeInformations(\"" + this.imf.getServiceName() + "\", \"" + this.imf.getEndpointName() + "\", \"" + m.getName() + "\", " + Method.generateListOfInputParameterNames(m) + ", response, " + Parameter.findType(m.getOutputParam().getType()) + ".class" + ", this.getGuiImplementation().getResponseType());\n"
                + "\t\t  this.getGuiImplementation().setVisible(true);\n"
                + "\t\t  while(this.getGuiImplementation().isVisible()) {\n"
                + "\t\t	 	// do nothing: Wait user action on gui\n"
                + "\t\t try{Thread.sleep(500);}catch(Exception e){e.printStackTrace();};\n"
                + "\t\t  }\n";


        if(!m.getOutputParam().getType().equals("void")) {
            res += "\t\t if(this.getGuiImplementation().getResponseType().equals(\"out\")){\n";
            res = res + "\t\t\t  response = (" + Parameter.findType(m.getOutputParam().getType()) + ") this.getGuiImplementation().getResponse();\n";
            res += "\t\t}";
            if(m.getExceptions().size()>0){
                try {
                    res += "\n\t\t\t else {";
                    res += "\n\t\t\t\t\t "+m.getExceptions().get(0)+" exx = new "+m.getExceptions().get(0)+
                            "(this.getGuiImplementation().getResponse().toString());";
                    res += "\n\t\t\t\t\t throw exx;";
                    res += "}";

                } catch (Exception ex1) {

                    Logger.getLogger(ImplementationManagerGenerator.class.getName()).log(Level.SEVERE, null, ex1);
                }

            }else{
                res+=";";
            }
        }   
        res = res + "\t\t}\n"
                + "\t\teventProducer.sendEventBeforeSendResponse(\"" + m.getName() + "\" ," + Method.generateListOfInputParameterNames(m) + ", response);\n";
        if(!m.getOutputParam().getType().equals("void")) {
            res = res + "\t\treturn response;\n";
        }

        return res;
    }


    public File generate(String basedir) throws IOException {
        String className = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length());
        className = className + "ImplementationManager";
        String packageName = FileUtil.createPackageNameFromTargetNamespace(this.tns);
        String folderName = basedir + "/" + packageName.replace(".", "/");
        File f = new File( folderName + "/" + className + ".java");
        f.createNewFile();

        FileWriter writer = null;
        try {
            writer = new FileWriter(f);

            // create package
            writer.write("package " + packageName + ";\n");
            writer.write("\n");

            // create imports
            for(String impt: imf.getImports()) {
                writer.write("import " + impt + ";\n");
            }
            // add specific import
            writer.write("import " + imf.getSignaturePackage() + "." + imf.getInterfaceName() + ";\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import org.petalslink.wsoui.context.WSOUIJaxbContext;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.notification.AbstractEventProducerNotifier;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.notification.SubscriptionManager;\n");
            writer.write("import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;\n");
            writer.write("import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;\n");
            writer.write("import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;\n");
            writer.write("import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;\n");
            writer.write("import org.w3c.dom.Document;\n");
            writer.write("import java.net.URL;\n");
            writer.write("import java.util.Enumeration;\n");
            writer.write("import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;\n");
            writer.write("import java.net.URLClassLoader;\n");
            writer.write("import java.util.ArrayList;\n");
            writer.write("import java.util.List;\n");
            writer.write("import java.io.File;");

            writer.write("\n");

            // create annotations class
            for(Annotation a: imf.getAnnotationClass()) {
                String annotation = "";
                annotation = a.getName() + "(\n";
                for(Entry<String, String> entry: a.getFields().entrySet()) {
                    if(entry.getKey().equals("wsdlLocation")) {
                        annotation = annotation + "\t" + entry.getKey() + " = \"" + imf.getWsdlLocation() + "\",\n";
                    } else {
                        annotation = annotation + "\t" + entry.getKey() + " = " + entry.getValue() + ",\n";
                    }
                }
                annotation = annotation.substring(0, annotation.length() - ",\n".length()) + ")\n";
                writer.write(annotation);
            }


            // create class
            writer.write("public class " + className + " extends AbstractImplementationManager<" + imf.getInterfaceName() + "> implements " + imf.getInterfaceName() + "{\n");
            writer.write("\n");

            // create variable
            writer.write("\tprivate AbstractEventProducerNotifier eventProducer = null;\n");
            writer.write("\tprivate WSOUIJaxbContextItf context = null;\n");
            writer.write("\n");

            // create default constructor
            String eventProducerClassName = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length()) + "_EventProducerNotifier";
            writer.write("\tpublic " + className + "(AbstractTestImplementation ti, URL wsdl) throws WSOUIException {\n");
            writer.write("\t\tsuper(ti, wsdl);\n");
            writer.write("\t\tcontext = new WSOUIJaxbContext();\n");
            writer.write("\t\tthis.getGuiImplementation().setWsouiContext(context);\n");
            writer.write("\t\tthis.eventProducer = new " + eventProducerClassName + "(this.getConfiguration(), context);\n");
            writer.write("\t}\n");
            writer.write("\n");



            // create constructor with activeGUI
            writer.write("\tpublic " + className + "(AbstractTestImplementation ti, URL wsdl, ProviderConfiguration configuration) throws WSOUIException {\n");
            writer.write("\t\tsuper(ti, wsdl, configuration);\n");
            writer.write("\t\tcontext = new WSOUIJaxbContext();\n");
            writer.write("\t\tthis.getGuiImplementation().setWsouiContext(context);\n");
            writer.write("\t\tthis.eventProducer = new " + eventProducerClassName + "(this.getConfiguration(), context);\n");
            writer.write("\t}\n");
            writer.write("\n");

            // create all methods
            for(Method m: imf.getSignatureMethods()) {

                writer.write("\tpublic " + m.getOutputParam().getType() + " " + m.getName() + "(" );

                // create input params
                String inputParams = "";
                for(Parameter inputParam: m.getInputParams()) {
                    inputParams = inputParams + inputParam.getType() + " " + inputParam.getName() + ", ";
                }
                inputParams = inputParams.substring(0, inputParams.length() - ", ".length()) + ") ";
                writer.write(inputParams);

                // create exception if exists
                if(m.getExceptions() != null && m.getExceptions().size() > 0) {
                    writer.write(" throws ");
                    String exceptions = "";
                    for(String exception: m.getExceptions()) {
                        exceptions = exceptions + exception + ", ";
                    }
                    exceptions = exceptions.substring(0, exceptions.length() - ", ".length());
                    writer.write(exceptions);
                }
                writer.write(" {\n");
                writer.write(this.generateImplementationMethod(m, basedir));
                writer.write("\t}\n\n\n");

            }

            writer.write("\n");
            writer.write("}\n");



        } finally{
            if(writer != null){
                writer.close();
            }
        }

        return f;
    }
}
