package org.petalslink.easiestdemo.wsoui.provided.notification;

import java.net.URI;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType.Topic;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

public abstract class AbstractEventProducerNotifier implements Runnable {

	private static Logger LOG = Logger.getLogger(AbstractEventProducerNotifier.class.getName());

	public static final int DEFAULT_THREAD_COUNTER = 1;

	private SubscriptionManager subscriptionManager = null;

	private int periodEvent = 0;

	private SOAPSender sender = new SOAPSender();

	private WSOUIJaxbContextItf context = null;

	private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

	private ProviderConfiguration configuration;

	public AbstractEventProducerNotifier(ProviderConfiguration configuration, WSOUIJaxbContextItf context) {
		this.subscriptionManager = new SubscriptionManager();
		this.context = context;
		this.configuration = configuration;
		setPeriodEvent();

		// Start the notifier in the thread worker
		scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(DEFAULT_THREAD_COUNTER);
		if(periodEvent > 0) {
			scheduledThreadPoolExecutor.scheduleWithFixedDelay(this, 0, this.periodEvent, TimeUnit.MILLISECONDS);
		}
	}

	public int getPeriodEvent() {
		return periodEvent;
	}

	public void setPeriodEvent(int periodEvent) {
		this.periodEvent = periodEvent;
	}

	public SubscriptionManager getSubscriptionManager() {
		return subscriptionManager;
	}

	public void sendEventBeforeProcessingRequest(String methodName, Object request) {
		NotificationBeforeProcessingRequestThread sender = new NotificationBeforeProcessingRequestThread(this, methodName, request);
		sender.start();
	}

	public void sendEventBeforeSendResponse(String methodName, Object request, Object response)  {
		NotificationBeforeSendResponseThread sender = new NotificationBeforeSendResponseThread(this, methodName, request, response);
		sender.start();
	}

	public abstract void setPeriodEvent();

	public abstract AbstractJaxbModelObject createPeriodicallyEvent() throws WSOUIException;

	public abstract AbstractJaxbModelObject createEventBeforeProcessingRequest(String methodName, Object request) throws WSOUIException;

	public abstract AbstractJaxbModelObject createEventBeforeSendResponse(String methodName, Object request, Object response) throws WSOUIException;

	@Override
	public void run() {
		try {
			// Create event
			AbstractJaxbModelObject event = createPeriodicallyEvent();

			// Send event
			sendEvent(event);
		} catch (ESBException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (WSOUIException e) {
			e.printStackTrace();
		}
	}

	public void sendEvent(AbstractJaxbModelObject event) throws ESBException,
	SOAPException {
		try {
			if(event != null) {
				Document doc = this.context.marshallAnyElement((Object)event);

				com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType.Message msg = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createNotificationMessageHolderTypeMessage(doc.getDocumentElement());
				com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType nmh = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createNotificationMessageHolderType(msg);

				
				EndpointReferenceType producerEpr = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
				Address producerAddress =  SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
				producerAddress.setValue(URI.create(configuration.getEndpointAddress()));
				producerEpr.setAddress(producerAddress);
				nmh.setProducerReference(producerEpr);
				
				com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify notify = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createNotify(nmh); 


				// notify
				com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType topic = findCorrespondingTopic(new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName()));
				if(topic != null) {
					nmh.setTopic(topic);
				}

				// add emission date
				Document emissionDate = createEmissionDate();
				
				notify.getAny().add(emissionDate.getDocumentElement());


				List<String> interestedClients = this.subscriptionManager.getInterestedClientByEvent(doc);
				for(String client: interestedClients) {
					System.out.println("88888888888888888888888888888888888888888888888 client = " + client);
					EndpointReferenceType subscriberEpr = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
					Address subscriberAddress =  SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
					subscriberAddress.setValue(URI.create(client));
					subscriberEpr.setAddress(subscriberAddress);
					nmh.setSubscriptionReference(subscriberEpr);
					
					doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);	
					
					LOG.finest("Send notification to " + client);
					this.sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest(doc), client, null);
				}
			}
		} catch (WSOUIException e) {
			throw new ESBException(e);
		} catch (JDOMException e) {
			throw new ESBException(e);
		} catch (WstopException e) {
			throw new ESBException(e);
		} catch (WsnbException e) {
			throw new ESBException(e);
		}
	}

	private com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType findCorrespondingTopic(QName qName) throws WstopException {
		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType notifyTopicExpr = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createTopicExpressionType(URI.create("http://www.w3.org/TR/1999/REC-xpath-19991116"));
		TopicNamespaceType topicNamespace = this.subscriptionManager.getTopicNamespace();
		if(topicNamespace != null) {
			for(Topic t: topicNamespace.getTopics()) {
				for(QName topicUsed: t.getMessageTypes()) {
					if(topicUsed.equals(qName)) {
						String prefix  = "top";
						notifyTopicExpr.addTopicNamespace(prefix, topicNamespace.getNamespace());
						notifyTopicExpr.setContent(prefix + ":" + t.getName());
						return notifyTopicExpr;
					}
				}
			}
		}
		LOG.warning("Impossible to find topic corresponding to this element \"" + qName + "\" in this topicnamespace: " + topicNamespace.getNamespace());
		return null;
	}

	private Document createEmissionDate() throws WSOUIException {
		Document doc = null;
		try {
			doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			Element emissionDate = doc.createElementNS("http://wwww.petalslink.com/wsoui/wsnotification", "emissionDate");
			emissionDate.setPrefix("ebm");
			emissionDate.setNodeValue(DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar) GregorianCalendar.getInstance()).toString());
			doc.appendChild(emissionDate);
		} catch (ParserConfigurationException e) {
			throw new WSOUIException(e);
		} catch (DOMException e) {
			throw new WSOUIException(e);
		} catch (DatatypeConfigurationException e) {
			throw new WSOUIException(e);
		} 

		return doc;
	}



}
