/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.bpel;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AssemblyFileCopier {
    private static final String ASSEMBLY = "assembly";
    private static final String ASSEMBLY_RUNTIME_XML = "assembly/runtime.xml";
    private static final String ASSEMBLY_DEV_XML = "assembly/dev.xml";
    private static final String ASSEMBLY_RSC_XML = "assembly/rsc.xml";
    private static final String ASSEMBLY_ZIP_XML = "assembly/zip.xml";
    private File target;

    public AssemblyFileCopier(File target) {
        this.target = target;
    }

    public void copyAssemblyFile() throws IOException {
        InputStream devIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_DEV_XML);
        InputStream runtimeIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_RUNTIME_XML);
        InputStream zipIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_ZIP_XML);
        InputStream rscIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_RSC_XML);
        File assemblyDir = new File(this.target + "/" + ASSEMBLY);
        assemblyDir.mkdirs();
        File devFile = new File(this.target + "/" + ASSEMBLY_DEV_XML);
        File runtimeFile = new File(this.target + "/" + ASSEMBLY_RUNTIME_XML);
        devFile.createNewFile();
        runtimeFile.createNewFile();
        FileOutputStream devOut = new FileOutputStream(devFile);
        FileOutputStream runtimeOut = new FileOutputStream(runtimeFile);
        FileUtil.copy((InputStream)devIn, (OutputStream)devOut);
        FileUtil.copy((InputStream)runtimeIn, (OutputStream)runtimeOut);
        devIn.close();
        runtimeIn.close();
        ((OutputStream)devOut).close();
        ((OutputStream)runtimeOut).close();
        File zipFile = new File(this.target + "/" + ASSEMBLY_ZIP_XML);
        File rscFile = new File(this.target + "/" + ASSEMBLY_RSC_XML);
        zipFile.createNewFile();
        rscFile.createNewFile();
        FileOutputStream zipOut = new FileOutputStream(zipFile);
        FileOutputStream rscOut = new FileOutputStream(rscFile);
        FileUtil.copy((InputStream)zipIn, (OutputStream)zipOut);
        FileUtil.copy((InputStream)rscIn, (OutputStream)rscOut);
        zipIn.close();
        rscIn.close();
        ((OutputStream)zipOut).close();
        ((OutputStream)rscOut).close();
    }
}

