package org.petalslink.easiestdemo.wsoui.plugin.wsdl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import com.ebmwebsourcing.easycommons.uri.URIHelper;

public class WsdlOption {


	/**
	 * The WSDL file to process.
	 */
	String wsdl;

	/** 
	 * The client configuration
	 */
	//  boolean client = false;

	/** 
	 * The provider configuration
	 */
	boolean provider = true;

	/**
	 * @parameter
	 */
	boolean generateBusinessClass = true;

	/**
	 * @parameter
	 */
	boolean overrideOlderBusinessClass = false;
	
	

	
	private URI relatifEventImport;
	private URI schemaLocationOfWsAddressing;


    public URI getRelatifEventImport() {
        return relatifEventImport;
    }


    public void setRelatifEventImport(URI relatifEventImport) {
        this.relatifEventImport = relatifEventImport;
    }



	public String getWsdl() {
		return wsdl;
	}

	public void setWsdl(String w) {
		wsdl = w;
	}


	public boolean getProvider() {
		return provider;
	}

	public void setProvider(boolean provider) {
		this.provider = provider;
	}



	public List<String> generateCommandLine(URI basedir, String generatedSource) throws WSOUIException {
		List<String> list = new ArrayList<String>();
		try {
			if(generatedSource != null) {
				list.add("-d");
				list.add(generatedSource);
			}

			WSOUIBindingGenerator gen = new WSOUIBindingGenerator(this);
			for(URI b: gen.generateBindings(this.getWsdl(), basedir)) {
			    list.add("-b");
	            list.add(b.toString());
			}
			

			if(provider) {
				list.add("-server");
			}

			if(provider) {
				list.add("-impl");
			}
			
			list.add("-noAddressBinding");
			list.add("-dns");
			list.add("false");


			list.add(FileUtil.getURI(basedir, this.getWsdl()).toString());
		} catch (IOException e) {
			throw new WSOUIException(e);
		} catch (URISyntaxException e) {
		    throw new WSOUIException(e);
        }
		return list;
	}


	@Override
    public String toString() {
        return "WsdlOption [wsdl=" + wsdl + ", provider=" + provider + ", generateBusinessClass="
                + generateBusinessClass + ", overrideOlderBusinessClass="
                + overrideOlderBusinessClass + "]";
    }


    public boolean isGenerateBusinessClass() {
		return generateBusinessClass;
	}

	public void setGenerateBusinessClass(boolean generateBusinessClass) {
		this.generateBusinessClass = generateBusinessClass;
	}

	public boolean isOverrideOlderBusinessClass() {
		return overrideOlderBusinessClass;
	}

	public void setOverrideOlderBusinessClass(boolean overrideOlderBusinessClass) {
		this.overrideOlderBusinessClass = overrideOlderBusinessClass;
	}


    public void setSchemaLocationOfWsAddressing(URI findSchemaLocationImportFromNamespace) {
        this.schemaLocationOfWsAddressing = findSchemaLocationImportFromNamespace;
    }
    
    public URI getSchemaLocationOfWsAddressing() {
        return schemaLocationOfWsAddressing;
    }
}
