package org.petalslink.easiestdemo.wsoui.provided.notification;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;

public class NotificationBeforeProcessingRequestThread extends Thread {

	private AbstractEventProducerNotifier eventProducerNotifier = null;
	private String methodName = null;
	private Object request = null;
	
	public NotificationBeforeProcessingRequestThread(AbstractEventProducerNotifier eventProducerNotifier, String methodName, Object request) {
		this.eventProducerNotifier = eventProducerNotifier;
		this.methodName = methodName;
		this.request = request;
	}
	
	@Override
	public void run() {
		try {
			AbstractJaxbModelObject event = eventProducerNotifier.createEventBeforeProcessingRequest(methodName, request);
			eventProducerNotifier.sendEvent(event);
		} catch (ESBException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (WSOUIException e) {
			e.printStackTrace();
		}
	}
	
	

}
