package org.petalslink.easiestdemo.wsoui.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.ESBWSDMFactoryImpl;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;

import easyesb.petalslink.com.data.admin._1.AdminFault;
import easyesb.petalslink.com.data.admin._1.StoreBpel;
import easyesb.petalslink.com.data.admin._1.StoreBpelResponse;
import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;

public final class ESBManagement {

	private static ESBManagement esbManagement = new ESBManagement();

	private ESBFactory esbFactory = new ESBFactoryImpl();

	private ESBFactory monitoringFactory = new ESBWSDMFactoryImpl();


	public static ESBManagement getInstance(){
		return ESBManagement.esbManagement;
	}

	private ESBManagement(){

	}

	public void setESBFactory(ESBFactory factory){
		esbFactory = factory;
	}

	public ESBFactory getESBFactory(){
		return esbFactory;
	}
	
	public void setMonitoringFactory(ESBFactory factory){
		monitoringFactory = factory;
	}

	public ESBFactory getMonitoringFactory(){
		return monitoringFactory;
	}


	public Node createMonitoringNode(QName name, String host, int port, int soap_port) throws ESBException{
		Configuration c = new ConfigurationImpl(false, host, port, new SoapServer(new SoapServerConfig(soap_port)));
		Node node = monitoringFactory.createNode(name, c);
		return node;
	}


	public Node createNode(QName name, String host, int port, int soap_port) throws ESBException {
		SoapServer soapServer = new SoapServer(new SoapServerConfig(soap_port));

		Configuration conf = new ConfigurationImpl(false, host, port, soapServer);

		Node node = esbFactory.createNode(name, conf);
		
		return node;
	}


	public List<URL> deployAndExposeBPEL(URL bpel, URL nodeUrl) throws AdminExceptionMsg {
		List<URL> res = new ArrayList<URL>();
		try {
			// create payload request
			StoreBpel payload = new StoreBpel();
			StoreBpelResponse storeBpelReponse = null;

			// store bpel 
			payload.setBpelUrl(bpel.toString());
			storeBpelReponse = ESBManagement.storeBpel(payload, nodeUrl.toString());

			for(String url: storeBpelReponse.getBpelEndpointAddress()) {
				res.add(new URL(url));
			}
		} catch (MalformedURLException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		}
		return res;
	}

	private static StoreBpelResponse storeBpel(StoreBpel payload, String address) throws AdminExceptionMsg {
		SOAPSender sender = new SOAPSender();
		SOAPHandler soapHandler = new SOAPHandler();
		StoreBpelResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = sender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/storeBpel");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild(doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, StoreBpelResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault");
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault");
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault");
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault");
		}
		return response;
	}
}
