/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

public class BPELJUnitTestGenerator {
    private List<String> allServerClassNames;
    private BPELProcess process;

    public BPELJUnitTestGenerator(BPELProcess process, List<String> allServerClassNames) throws WSOUIException {
        this.allServerClassNames = allServerClassNames;
        this.process = process;
    }

    public File generate(String bpelUrl, String basedir) throws IOException {
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.process.getTargetNamespace());
        String className = String.valueOf(this.process.getName()) + "_BPELTest";
        className = String.valueOf(className.substring(0, 1).toUpperCase()) + className.substring(1, className.length());
        File dir = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = FileUtil.createFile((String)className, (String)packageName, (String)basedir, (String)".java", (boolean)true);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("import org.junit.Test;\n");
            writer.write("import org.junit.Assert;\n");
            writer.write("import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;\n");
            writer.write("import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;\n");
            writer.write("import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;\n");
            writer.write("\n");
            writer.write("public class " + className + "{\n");
            writer.write("\n");
            writer.write("\t@Test\n");
            writer.write("\tpublic void valid" + this.process.getName().substring(0, 1).toUpperCase() + this.process.getName().substring(1, this.process.getName().length()) + "() throws Exception {\n");
            writer.write("\t\tBPELValidator validator = new BPELValidator();\n");
            writer.write("\t\tValidatorResult report = validator.validate(" + this.process.getName().substring(0, 1).toUpperCase() + this.process.getName().substring(1, this.process.getName().length()) + "_Main.BPEL_LOCATION" + ");\n");
            writer.write("\t\tif(report.getErrors().size() > 0) {\n");
            writer.write("\t\t\tthrow new Exception(ValidatorResultPrinter.getInstance().printAll(report));\n");
            writer.write("\t\t} else {\n");
            writer.write("\t\t\tSystem.out.println(ValidatorResultPrinter.getInstance().printAll(report));\n");
            writer.write("\t\t}\n");
            writer.write("\t}\n");
            writer.write("\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }
}

