/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

public class BPELProcessGenerator {
    private List<String> allServerClassNames;
    private BPELProcess process;
    private boolean override;

    public BPELProcessGenerator(BPELProcess process, List<String> allServerClassNames, boolean override) throws WSOUIException {
        this.allServerClassNames = allServerClassNames;
        this.process = process;
        this.override = override;
    }

    private String generateStartAllWebServices() {
        String res = "";
        res = "\tpublic void startAllWebServices() throws WSOUIException {\n";
        res = String.valueOf(res) + "\t\tif(!isStandalone()) {\n";
        for (String server : this.allServerClassNames) {
            res = String.valueOf(res) + "\t\t\t" + this.createVariableName(server) + " = new " + FileUtil.createShortClassName((String)server) + "();\n";
            res = String.valueOf(res) + "\t\t\t" + this.createVariableName(server) + ".start();\n";
        }
        res = String.valueOf(res) + "\t\t}\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateStartClient() {
        String res = "";
        res = "\tpublic void createClient() throws WSOUIException {\n";
        res = String.valueOf(res) + "\t\ttry {\n";
        res = String.valueOf(res) + "\t\t\tWSOUIClient client = new WSOUIClient();\n";
        res = String.valueOf(res) + "\t\t\torg.petalslink.easiestdemo.client.model.api.esb.Node n = client.addNewAdminWsdlofESBNode(new URL(adminUrl + \"?wsdl\"));\n";
        res = String.valueOf(res) + "\t\t\tn.setModel(node);\n";
        res = String.valueOf(res) + "\t\t\tclient.setVisible(true);\n";
        res = String.valueOf(res) + "\t\t} catch (MalformedURLException e) {\n";
        res = String.valueOf(res) + "\t\t\tthrow new WSOUIException(e);\n";
        res = String.valueOf(res) + "\t\t} catch (WSOUIClientException e) {\n";
        res = String.valueOf(res) + "\t\t\tthrow new WSOUIException(e);\n";
        res = String.valueOf(res) + "\t\t}\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateSetGUIOnAllWebServices() {
        String res = "";
        res = "\tpublic void setGUIOnAllWebServices(boolean activeGUI) throws WSOUIException {\n";
        res = String.valueOf(res) + "\t\tif(!isStandalone()) {\n";
        for (String server : this.allServerClassNames) {
            res = String.valueOf(res) + "\t\tif(" + this.createVariableName(server) + " != null) {\n";
            res = String.valueOf(res) + "\t\t\t" + this.createVariableName(server) + ".getProviderConfigurationFor_" + this.createInterfaceName(server) + "().setActiveGui(activeGUI);\n";
            res = String.valueOf(res) + "\t\t}\n";
        }
        res = String.valueOf(res) + "\t\t}\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateStopAllWebServices() {
        String res = "";
        res = "\tpublic void stopAllWebServices() {\n";
        res = String.valueOf(res) + "\t\tif(!isStandalone()) {\n";
        for (String server : this.allServerClassNames) {
            res = String.valueOf(res) + "\t\tif(" + this.createVariableName(server) + " != null) {\n";
            res = String.valueOf(res) + "\t\t\t" + this.createVariableName(server) + ".stop();\n";
            res = String.valueOf(res) + "\t\t}\n";
        }
        res = String.valueOf(res) + "\t\t}\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateAnalyzeCommand() {
        String res = "";
        res = String.valueOf(res) + "\tpublic static void analyzeCommand(String args[]) {\n";
        res = String.valueOf(res) + "\t\tif(args != null && args.length == 1 && args[0].equals(\"standalone\")) {\r\n";
        res = String.valueOf(res) + "\t\t\tstandalone = true;\r\n";
        res = String.valueOf(res) + "\t\t}\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateIsStandalone() {
        String res = "";
        res = String.valueOf(res) + "\tpublic boolean isStandalone() {\r\n";
        res = String.valueOf(res) + "\t\treturn standalone;\r\n";
        res = String.valueOf(res) + "\t}";
        return res;
    }

    private String generateCreateNode(String esbFactory) {
        String res = "";
        res = "\tpublic void createNode() throws ESBException {\n";
        if (esbFactory != null) {
            res = String.valueOf(res) + "\t\tESBManagement.getInstance().setESBFactory(new " + esbFactory + "());\n";
        }
        res = String.valueOf(res) + "\t\tthis.node = ESBManagement.getInstance().createNode(nodeName, nodeHost, nodeInternalPort, nodeSoapPort);\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateStopNode() {
        String res = "";
        res = "\tpublic void stopNode() throws TransportException {\n";
        res = String.valueOf(res) + "\t\tthis.node.stop();\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateDeployAndExposeBPEL() {
        String res = "";
        res = "\tpublic List<URL> deployAndExposeBPEL(URL bpel) throws MalformedURLException, AdminExceptionMsg {\n";
        res = String.valueOf(res) + "\t\tList<URL> urls = ESBManagement.getInstance().deployAndExposeBPEL(bpel, new URL(adminUrl));\n";
        res = String.valueOf(res) + "\n";
        res = String.valueOf(res) + "\t\tSystem.out.println(\"BPEL \" + bpel + \" are exposed at url:\");\n";
        res = String.valueOf(res) + "\t\tfor(URL url: urls) {\n";
        res = String.valueOf(res) + "\t\t\tSystem.out.println(\"\t\" + url);\n";
        res = String.valueOf(res) + "\t\t}\n";
        res = String.valueOf(res) + "\t\treturn urls;\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    private String generateMain(String bpelUrl, String className) {
        String res = "";
        res = "\tpublic static void main(String args[]) throws Exception {\n";
        res = String.valueOf(res) + "\t\t" + FileUtil.createShortClassName((String)className) + " main = new " + FileUtil.createShortClassName((String)className) + "();\n";
        res = String.valueOf(res) + "\t\tPrintStream err = System.err;\n";
        res = String.valueOf(res) + "\t\ttry {\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\tboolean activeGUI = true;\n";
        res = String.valueOf(res) + "\t\t\tanalyzeCommand(args);\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\t// Create and Start all WebServices\n";
        res = String.valueOf(res) + "\t\t\tmain.startAllWebServices();\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\t// Set GUI on all WebServices\n";
        res = String.valueOf(res) + "\t\t\tmain.setGUIOnAllWebServices(activeGUI);\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\t// Create EasyESB node\n";
        res = String.valueOf(res) + "\t\t\tmain.createNode();\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\t// Deploy and Expose BPEL\n";
        res = String.valueOf(res) + "\t\t\tList<URL> bpelUrls = main.deployAndExposeBPEL(" + FileUtil.createShortClassName((String)className) + ".BPEL_LOCATION);\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\t// Create and Start client\n";
        res = String.valueOf(res) + "\t\t\tif(activeGUI) {\n";
        res = String.valueOf(res) + "\t\t\t\tmain.createClient();\n";
        res = String.valueOf(res) + "\t\t\t}\n";
        res = String.valueOf(res) + "\t\t\t// Exit\n";
        res = String.valueOf(res) + "\t\t\tScanner sc = new Scanner(System.in);\n";
        res = String.valueOf(res) + "\t\t\tSystem.out.println(\"Hit Enter to exit :\");\n";
        res = String.valueOf(res) + "\t\t\tsc.nextLine();\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t} catch(Exception e) {\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\te.printStackTrace(err);\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\t// Stop all WebServices\n";
        res = String.valueOf(res) + "\t\t\tmain.stopAllWebServices();\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t\t// Stop node\n";
        res = String.valueOf(res) + "\t\t\tmain.stopNode();\n";
        res = String.valueOf(res) + "\t\t\n";
        res = String.valueOf(res) + "\t\t}\n";
        res = String.valueOf(res) + "\t}\n";
        return res;
    }

    public File generate(String bpelUrl, String basedir, String esbFactory) throws IOException {
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.process.getTargetNamespace());
        String className = String.valueOf(this.process.getName()) + "_Main";
        className = String.valueOf(className.substring(0, 1).toUpperCase()) + className.substring(1, className.length());
        File dir = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = FileUtil.createFile((String)className, (String)packageName, (String)basedir, (String)".java", (boolean)this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            for (String serverName : this.allServerClassNames) {
                writer.write("import " + serverName + ";\n");
            }
            writer.write("import java.net.URL;\n");
            writer.write("import java.util.List;\n");
            writer.write("import java.util.Scanner;\n");
            writer.write("import javax.xml.namespace.QName;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.util.ESBManagement;\n");
            writer.write("import com.ebmwebsourcing.easyesb.soa.api.node.Node;\n");
            writer.write("import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;\n");
            writer.write("import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;\n");
            writer.write("import com.ebmwebsourcing.easyesb.soa.api.ESBException;\n");
            writer.write("import org.petalslink.easiestdemo.client.WSOUIClient;\n");
            writer.write("import org.petalslink.easiestdemo.client.WSOUIClientException;\n");
            writer.write("import java.net.MalformedURLException;\n");
            writer.write("import org.petalslink.abslayer.service.api.Description;\n");
            writer.write("import java.util.ArrayList;\n");
            writer.write("import com.ebmwebsourcing.easybox.api.XmlObjectReadException;\n");
            writer.write("import java.lang.Exception;\n");
            writer.write("import java.io.InputStream;\n");
            writer.write("import java.io.PrintStream;\n");
            writer.write("import java.util.logging.LogManager;\n");
            writer.write("\n");
            writer.write("public class " + className + " {\n");
            writer.write("\n");
            writer.write("\tpublic final static URL BPEL_LOCATION;\n");
            writer.write("\tstatic {\n");
            writer.write("\t    BPEL_LOCATION = Thread.currentThread().getContextClassLoader().getResource(\"" + bpelUrl + "\");\n");
            writer.write("\t}\n\n");
            writer.write("\tstatic {\n");
            writer.write("\t\ttry {\n");
            writer.write("\t\t\tInputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(\"logger/easiestdemo-logging.properties\");\n");
            writer.write("\t\t\tLogManager.getLogManager().readConfiguration(configFile);\n");
            writer.write("\t\t} catch (Exception ex)\n");
            writer.write("\t\t{\n");
            writer.write("\t\t\tSystem.out.println(\"WARNING: Could not open configuration file\");\n");
            writer.write("\t\t\tSystem.out.println(\"WARNING: Logging not configured (console output only)\");\n");
            writer.write("\t\t}\n");
            writer.write("\t}\n");
            for (String server : this.allServerClassNames) {
                writer.write("\tprivate " + FileUtil.createShortClassName((String)server) + " " + this.createVariableName(server) + " = null;\n");
            }
            writer.write("\n");
            writer.write("\tprivate Node node = null;\n");
            writer.write("\tprivate QName nodeName = new QName(\"" + this.process.getTargetNamespace() + "\", \"" + this.process.getName() + "_EasyESBNode\");\n");
            writer.write("\tprivate String nodeHost = \"localhost\";\n");
            writer.write("\tprivate int nodeInternalPort = 8000;\n");
            writer.write("\tprivate int nodeSoapPort = 8085;\n");
            writer.write("\tprivate String adminUrl = \"http://\" + nodeHost + \":\" + nodeSoapPort + \"/services/adminExternalEndpoint\";\n");
            writer.write("\n");
            writer.write("\tprivate static boolean standalone = false;\n");
            writer.write("\n\n");
            String main = this.generateMain(bpelUrl, className);
            writer.write(main);
            writer.write("\n\n");
            String analyzeCommand = this.generateAnalyzeCommand();
            writer.write(analyzeCommand);
            writer.write("\n\n");
            String isStandalone = this.generateIsStandalone();
            writer.write(isStandalone);
            writer.write("\n\n");
            String createNode = this.generateCreateNode(esbFactory);
            writer.write(createNode);
            writer.write("\n\n");
            String deployAndExposeBpel = this.generateDeployAndExposeBPEL();
            writer.write(deployAndExposeBpel);
            writer.write("\n\n");
            String stopNode = this.generateStopNode();
            writer.write(stopNode);
            writer.write("\n\n");
            String startAllWebServices = this.generateStartAllWebServices();
            writer.write(startAllWebServices);
            writer.write("\n\n");
            String startClient = this.generateStartClient();
            writer.write(startClient);
            writer.write("\n\n");
            String setGUIOnAllWebServices = this.generateSetGUIOnAllWebServices();
            writer.write(setGUIOnAllWebServices);
            writer.write("\n\n");
            String stopAllWebServices = this.generateStopAllWebServices();
            writer.write(stopAllWebServices);
            writer.write("\n\n");
            writer.write("\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    private String createVariableName(String clazz) {
        String varName = clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length());
        varName = String.valueOf(varName.substring(0, 1).toLowerCase()) + varName.substring(1, varName.length());
        return varName;
    }

    private String createInterfaceName(String clazz) {
        String shortClass = FileUtil.createShortClassName((String)clazz).replace("_WSOUIServer", "");
        return shortClass;
    }
}

