/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

public class UnixScriptsGenerator {
    private static final String SCRIPTS = "scripts";
    private static final String GLOBAL_SCRIPTS = "global-scripts";
    private String projectName;
    private String version;
    private List<String> allServerClassNames;
    private BPELProcess process;
    private boolean override;

    public UnixScriptsGenerator(String projectName, String version, BPELProcess process, List<String> allServerClassNames, boolean override) throws WSOUIException {
        this.allServerClassNames = allServerClassNames;
        this.process = process;
        this.override = override;
        this.projectName = projectName;
        this.version = version;
    }

    public File generateScript(String fileName, String className, String basedir) throws IOException {
        File scriptDir = new File(String.valueOf(basedir) + "/" + SCRIPTS);
        scriptDir.mkdirs();
        File res = FileUtil.createFile((String)fileName, (String)(String.valueOf(basedir) + "/" + SCRIPTS), (String)".sh", (boolean)this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(res);
            writer.write("#!/bin/sh\n");
            writer.write("if [ ! -d \"$JAVA_HOME\" ]\n");
            writer.write("then\n");
            writer.write("\techo \"The JAVA_HOME variable is not properly set. Please set it in your environment.\"\n");
            writer.write("\texit 2\n");
            writer.write("fi\n");
            writer.write("if [ ! -d \"$MAVEN_HOME\" ]\n");
            writer.write("then\n");
            writer.write("\techo \"The MAVEN_HOME variable is not properly set. Trying /usr/ value.\"\n");
            writer.write("\texport MAVEN_HOME=/usr/\n");
            writer.write("fi\n");
            writer.write("echo launching " + className + " with command line :\n");
            writer.write("echo java  -cp \"" + this.projectName + "-" + this.version + ".jar\" " + className + " standalone \n");
            writer.write("java  -cp \"" + this.projectName + "-" + this.version + ".jar\" " + className + " standalone \n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        res.setExecutable(true);
        return res;
    }

    public List<File> generateAllScripts(String basedir) throws IOException {
        ArrayList<File> res = new ArrayList<File>();
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.process.getTargetNamespace());
        String className = String.valueOf(this.process.getName()) + "_Main";
        className = String.valueOf(className.substring(0, 1).toUpperCase()) + className.substring(1, className.length());
        res.add(this.generateScript("StartBPEL_" + this.process.getName(), String.valueOf(packageName) + "." + className, basedir));
        for (String providerClass : this.allServerClassNames) {
            res.add(this.generateScript("StartProvider_" + FileUtil.createShortClassName((String)providerClass), providerClass, basedir));
        }
        res.add(this.generateStartESBScript(basedir));
        res.add(this.generateStartProvidersScript(basedir));
        res.add(this.generateStartAllScript(basedir));
        return res;
    }

    private File generateStartAllScript(String basedir) throws IOException {
        File scriptDir = new File(String.valueOf(basedir) + "/" + GLOBAL_SCRIPTS);
        scriptDir.mkdirs();
        File res = FileUtil.createFile((String)"StartAll", (String)(String.valueOf(basedir) + "/" + GLOBAL_SCRIPTS), (String)".sh", (boolean)this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(res);
            writer.write("#!/bin/sh\n");
            writer.write("echo \"START All\"\n");
            writer.write("xterm -e \"./StartProviders.sh \" &\n");
            writer.write("xterm -e \"./StartESB.sh  \" &\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        res.setExecutable(true);
        return res;
    }

    private File generateStartProvidersScript(String basedir) throws IOException {
        File scriptDir = new File(String.valueOf(basedir) + "/" + GLOBAL_SCRIPTS);
        scriptDir.mkdirs();
        File res = FileUtil.createFile((String)"StartProviders", (String)(String.valueOf(basedir) + "/" + GLOBAL_SCRIPTS), (String)".sh", (boolean)this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(res);
            writer.write("#!/bin/sh\n");
            writer.write("echo \"START All providers\"\n");
            writer.write("cd bin\n");
            for (String providerClass : this.allServerClassNames) {
                writer.write("xterm -e \"./StartProvider_" + FileUtil.createShortClassName((String)providerClass) + ".sh \" & \n");
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        res.setExecutable(true);
        return res;
    }

    private File generateStartESBScript(String basedir) throws IOException {
        File scriptDir = new File(String.valueOf(basedir) + "/" + GLOBAL_SCRIPTS);
        scriptDir.mkdirs();
        File res = FileUtil.createFile((String)"StartESB", (String)(String.valueOf(basedir) + "/" + GLOBAL_SCRIPTS), (String)".sh", (boolean)this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(res);
            writer.write("#!/bin/sh\n");
            writer.write("echo \"START EasyESB\"\n");
            writer.write("cd bin\n");
            writer.write("xterm -e \"./StartBPEL_" + this.process.getName() + ".sh \" \n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        res.setExecutable(true);
        return res;
    }
}

