/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.reflexive;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.io.FileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Annotation;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Method;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Parameter;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;

public class ImplMetaInf {
    private String signaturePackage;
    private List<String> signatureImports;
    private String className;
    private String interfaceName;
    private String serviceName;
    private String endpointName;
    private String wsdlLocation;
    private String targetNamespace;
    private List<String> signatureStateVariable;
    private List<Method> signatureMethods;
    private List<Annotation> annotationClass;
    private ProviderConfiguration conf = new ProviderConfiguration();
    private File wsdl;

    public ImplMetaInf(File cxfImplementation, File wsdl) throws WSOUIException {
        try {
            Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "File : " + cxfImplementation);
            FileReader fr = new FileReader(cxfImplementation);
            List<String> linesWithoutComments = this.deleteAllComments(fr.getLines());
            this.signaturePackage = this.findPackage(linesWithoutComments);
            this.signatureImports = this.findAllImports(linesWithoutComments);
            this.annotationClass = this.findAllClassAnnotation(linesWithoutComments);
            this.className = this.findClassName(linesWithoutComments);
            this.interfaceName = this.findInterfaceName(linesWithoutComments);
            this.signatureStateVariable = this.findAllStateVariables(linesWithoutComments);
            this.signatureMethods = this.findAllMethods(linesWithoutComments, cxfImplementation);
            this.serviceName = this.findServiceName(this.annotationClass);
            this.endpointName = this.findEndpointName(this.annotationClass);
            this.wsdlLocation = this.findWsdlLocation(this.annotationClass);
            this.targetNamespace = this.findTargetNamespace(this.annotationClass);
        }
        catch (SOAException e) {
            throw new WSOUIException(e);
        }
    }

    private String findEndpointName(List<Annotation> annotationClass) {
        String res = null;
        for (Annotation a : annotationClass) {
            if (a.getFields().get("portName") == null) continue;
            res = a.getFields().get("portName").replace("\"", "");
            break;
        }
        return res;
    }

    private String findWsdlLocation(List<Annotation> annotationClass) {
        String res = null;
        for (Annotation a : annotationClass) {
            if (a.getFields().get("wsdlLocation") == null) continue;
            res = a.getFields().get("wsdlLocation");
            if (res.contains("/main/resources/")) {
                res = res.substring(res.indexOf("/main/resources/") + "/main/resources/".length(), res.length()).replace("\"", "");
                break;
            }
            if (res.contains("/test/resources/")) {
                res = res.substring(res.indexOf("/test/resources/") + "/test/resources/".length(), res.length()).replace("\"", "");
                break;
            }
            if (res.contains("/classes/")) {
                res = res.substring(res.indexOf("/classes/") + "/classes/".length(), res.length()).replace("\"", "");
                break;
            }
            if (!res.contains("/test-classes/")) break;
            res = res.substring(res.indexOf("/test-classes/") + "/test-classes/".length(), res.length()).replace("\"", "");
            break;
        }
        return res;
    }

    private String findServiceName(List<Annotation> annotationClass) {
        String res = null;
        for (Annotation a : annotationClass) {
            if (a.getFields().get("serviceName") == null) continue;
            res = a.getFields().get("serviceName").replace("\"", "");
            break;
        }
        return res;
    }

    private String findTargetNamespace(List<Annotation> annotationClass) {
        String res = null;
        for (Annotation a : annotationClass) {
            if (a.getFields().get("targetNamespace") == null) continue;
            res = a.getFields().get("targetNamespace").replace("\"", "");
            break;
        }
        return res;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public ProviderConfiguration getConf() {
        return this.conf;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public List<String> getImports() {
        return this.signatureImports;
    }

    public void setImports(List<String> imports) {
        this.signatureImports = imports;
    }

    public List<Method> getSignatureMethods() {
        return this.signatureMethods;
    }

    public void setSignatureMethods(List<Method> signatureMethods) {
        this.signatureMethods = signatureMethods;
    }

    public List<Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(List<Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public List<String> getSignatureStateVariablbe() {
        return this.signatureStateVariable;
    }

    public void setSignatureStateVariablbe(List<String> signatureStateVariablbe) {
        this.signatureStateVariable = signatureStateVariablbe;
    }

    public List<String> getSignatureImports() {
        return this.signatureImports;
    }

    public void setSignatureImports(List<String> signatureImports) {
        this.signatureImports = signatureImports;
    }

    public String getSignaturePackage() {
        return this.signaturePackage;
    }

    public void setSignaturePackage(String signaturePackage) {
        this.signaturePackage = signaturePackage;
    }

    private String findPackage(List<String> lines) {
        String signaturePAckage = null;
        for (String line : lines) {
            if (!line.trim().startsWith("package")) continue;
            signaturePAckage = line.trim().substring(line.trim().indexOf("package") + "package".length(), line.trim().indexOf(";")).trim();
            break;
        }
        return signaturePAckage;
    }

    private List<String> findAllImports(List<String> lines) {
        ArrayList<String> imports = new ArrayList<String>();
        for (String line : lines) {
            if (!line.trim().startsWith("import")) continue;
            imports.add(line.trim().substring(line.trim().indexOf("import") + "import".length(), line.trim().indexOf(";")).trim());
        }
        return imports;
    }

    private List<Annotation> findAllClassAnnotation(List<String> lines) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Annotation a = null;
        boolean find = false;
        for (String line : lines) {
            if (find && line.trim().length() > 0 && !line.trim().contains(" class ")) {
                String nameField = line.trim().substring(0, line.trim().indexOf("=")).trim();
                String valueField = line.trim().substring(line.trim().indexOf("=") + 1, line.trim().length() - 1).trim();
                a.getFields().put(nameField, valueField);
            }
            if (line.trim().startsWith("@")) {
                if (a != null) {
                    annotations.add(a);
                }
                a = new Annotation();
                String annotationName = line.substring(0, line.indexOf("(")).trim();
                a.setName(annotationName);
                find = true;
            }
            if (!line.trim().contains(" class ")) continue;
            if (a == null) break;
            annotations.add(a);
            break;
        }
        return annotations;
    }

    private String findClassName(List<String> lines) {
        String className = "";
        for (String line : lines) {
            if (!line.trim().contains(" class ")) continue;
            className = line.trim().substring(line.trim().indexOf(" class ") + " class ".length(), line.trim().indexOf(" implements ")).trim();
            break;
        }
        return className;
    }

    private String findInterfaceName(List<String> lines) {
        String interfaceName = "";
        for (String line : lines) {
            if (!line.trim().contains(" implements ")) continue;
            interfaceName = line.trim().substring(line.trim().indexOf(" implements ") + " implements ".length(), line.trim().indexOf("{")).trim();
            break;
        }
        return interfaceName;
    }

    private List<String> findAllStateVariables(List<String> lines) {
        ArrayList<String> variables = new ArrayList<String>();
        for (String line : lines) {
            if (!line.trim().startsWith("private") || !line.trim().endsWith(";")) continue;
            variables.add(line.trim());
        }
        return variables;
    }

    /*
     * Unable to fully structure code
     */
    private List<Method> findAllMethods(List<String> lines, File classFile) throws WSOUIException {
        methods = new ArrayList<Method>();
        classDetected = false;
        for (String line : lines) {
            block12: {
                block14: {
                    block13: {
                        if (!classDetected || !line.trim().startsWith("public")) break block12;
                        deletePublic = line.trim().substring(line.trim().indexOf("public") + "public".length()).trim();
                        outputParamType = deletePublic.trim().substring(0, deletePublic.indexOf(" ")).trim();
                        outputParameter = new Parameter();
                        outputParameter.setType(outputParamType);
                        deleteOutputParam = deletePublic.trim().substring(deletePublic.indexOf(" ")).trim();
                        isConstructor = false;
                        if (outputParamType.contains("(")) {
                            isConstructor = true;
                        }
                        if (isConstructor) break block12;
                        methodName = deleteOutputParam.trim().substring(0, deleteOutputParam.trim().indexOf("(")).trim();
                        inputParams = new ArrayList<String>();
                        deleteMethodName = deleteOutputParam.substring(deleteOutputParam.trim().indexOf("(") + 1);
                        allInputParams = deleteMethodName.substring(0, deleteMethodName.indexOf(")"));
                        st = new StringTokenizer(allInputParams, ",");
                        if (st.countTokens() != 0) ** GOTO lbl25
                        inputParams.add(allInputParams.trim());
                        break block13;
lbl-1000:
                        // 1 sources

                        {
                            inputParams.add(st.nextToken().trim());
lbl25:
                            // 2 sources

                            ** while (st.hasMoreTokens())
                        }
                    }
                    inputParameters = new ArrayList<Parameter>();
                    for (String param : inputParams) {
                        inputParameter = new Parameter();
                        inputParameter.setType(param.split(" ")[0].trim());
                        inputParameter.setName(param.split(" ")[1].trim());
                        inputParameters.add(inputParameter);
                    }
                    if (inputParameters.size() > 1) {
                        throw new WSOUIException("[CXF Restriction]: Your wsdl description must be document litteral wrapped to be sure that the code generation would be ok!!!");
                    }
                    exceptions = new ArrayList<String>();
                    if (!line.contains("throws")) break block14;
                    allExceptions = deleteMethodName.substring(deleteMethodName.indexOf("throws") + "throws".length(), deleteMethodName.indexOf("{"));
                    st = new StringTokenizer(allExceptions, ",");
                    if (st.countTokens() != 0) ** GOTO lbl66
                    try {
                        Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "One Exception Thrown for " + methodName + " : " + allExceptions.trim());
                        ex = allExceptions.trim();
                        for (String import_ : this.signatureImports) {
                            if (!import_.contains(ex)) continue;
                            ex = import_;
                            break;
                        }
                        exceptions.add(ex);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ImplMetaInf.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            token = st.nextToken().trim();
                            for (String import_ : this.signatureImports) {
                                if (!import_.contains(token)) continue;
                                token = import_;
                                break;
                            }
                            exceptions.add(token);
                            continue;
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ImplMetaInf.class.getName()).log(Level.SEVERE, null, ex);
                        }
lbl66:
                        // 3 sources

                        ** while (st.hasMoreTokens())
                    }
                }
                m = new Method();
                m.setName(methodName);
                m.setOutputParam(outputParameter);
                m.setInputParams(inputParameters);
                m.setExceptions(exceptions);
                methods.add(m);
            }
            if (!line.trim().contains(" class ")) continue;
            classDetected = true;
        }
        return methods;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    private List<String> deleteAllComments(List<String> lines) {
        ArrayList<String> linesWithoutComments = new ArrayList<String>();
        for (String line : lines) {
            if (line.trim().startsWith("*") || line.trim().startsWith("/*")) continue;
            linesWithoutComments.add(line);
        }
        return linesWithoutComments;
    }

    public String toString() {
        return "ImplMetaInf [signaturePackage=" + this.signaturePackage + ", signatureImports=" + this.signatureImports + ", className=" + this.className + ", interfaceName=" + this.interfaceName + ", serviceName=" + this.serviceName + ", endpointName=" + this.endpointName + ", wsdlLocation=" + this.wsdlLocation + ", signatureStateVariable=" + this.signatureStateVariable + ", signatureMethods=" + this.signatureMethods + ", annotationClass=" + this.annotationClass + ", conf=" + this.conf + ", wsdl=" + this.wsdl + "]";
    }
}

