/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.wsdl;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;

public class EventProducerNotifierGenerator {
    private String topicSet;
    private String topicNamespace;
    private ImplMetaInf imf;
    private boolean override = false;
    private String tns;

    public EventProducerNotifierGenerator(String tns, ImplMetaInf imf, String topicSet, String topicnamespace, boolean override) throws WSOUIException {
        this.imf = imf;
        this.override = override;
        this.tns = tns;
        this.topicSet = topicSet;
        this.topicNamespace = topicnamespace;
    }

    public File generate(String basedir) throws IOException {
        String className = String.valueOf(this.imf.getServiceName().substring(0, 1).toUpperCase()) + this.imf.getServiceName().substring(1, this.imf.getServiceName().length());
        className = String.valueOf(className) + "_EventProducerNotifier";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        File dir = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = FileUtil.createFile((String)className, (String)packageName, (String)basedir, (String)".java", (boolean)this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            for (String impt : this.imf.getImports()) {
                writer.write("import " + impt + ";\n");
            }
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.notification.AbstractEventProducerNotifier;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;\n");
            writer.write("import java.net.URL;\n");
            writer.write("import java.net.MalformedURLException;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.notification.SubscriptionManager;\n");
            writer.write("\n");
            writer.write("public class " + className + " extends AbstractEventProducerNotifier {\n");
            writer.write("\n");
            writer.write("\tpublic " + className + "(ProviderConfiguration configuration, WSOUIJaxbContextItf context) throws WSOUIException {\n");
            writer.write("\t\tsuper(configuration, context);\n");
            if (this.topicSet != null) {
                writer.write("\t\tthis.getSubscriptionManager().setTopicSet(Thread.currentThread().getContextClassLoader().getResource(\"" + this.topicSet + "\"));\n");
            }
            if (this.topicNamespace != null) {
                writer.write("\t\tthis.getSubscriptionManager().setTopicNamespace(Thread.currentThread().getContextClassLoader().getResource(\"" + this.topicNamespace + "\"));\n");
            }
            writer.write("\t}\n");
            writer.write("\n");
            writer.write("\t@Override\n");
            writer.write("\tpublic void setPeriodEvent() {\n");
            writer.write("\t\tthis.setPeriodEvent(0); // Set the period to send event (in ms).\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\t@Override\n");
            writer.write("\tpublic AbstractJaxbModelObject createPeriodicallyEvent() throws WSOUIException {\n");
            writer.write("\t\tAbstractJaxbModelObject event = null; // TODO: create Event.\n");
            writer.write("\t\treturn event;\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\t@Override\n");
            writer.write("\tpublic AbstractJaxbModelObject createEventBeforeProcessingRequest(String methodName, Object request) throws WSOUIException {\n");
            writer.write("\t\tAbstractJaxbModelObject event = null; // TODO: create Event.\n");
            writer.write("\t\treturn event;\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\t@Override\n");
            writer.write("\tpublic AbstractJaxbModelObject createEventBeforeSendResponse(String methodName, Object request, Object response) throws WSOUIException {\n");
            writer.write("\t\tAbstractJaxbModelObject event = null; // TODO: create Event.\n");
            writer.write("\t\treturn event;\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }
}

