/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.wsdl;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Annotation;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;

public class ServiceGenerator {
    private ImplMetaInf imf;
    private String tns;

    public ServiceGenerator(String tns, ImplMetaInf imf) throws WSOUIException {
        this.imf = imf;
        this.tns = tns;
    }

    public File generate(String basedir) throws IOException {
        String className = String.valueOf(this.imf.getServiceName().substring(0, 1).toUpperCase()) + this.imf.getServiceName().substring(1, this.imf.getServiceName().length());
        className = String.valueOf(className) + "_WSOUIService";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        File f = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/") + "/" + className + ".java");
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("import " + this.imf.getSignaturePackage() + "." + this.imf.getInterfaceName() + ";\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.WSOUIService;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import java.net.URL;\n");
            writer.write("import javax.xml.namespace.QName;\n");
            writer.write("import javax.xml.ws.WebEndpoint;\n");
            writer.write("import javax.xml.ws.WebServiceClient;\n");
            writer.write("import javax.xml.ws.WebServiceFeature;\n");
            writer.write("import javax.xml.ws.Service;\n");
            writer.write("\n");
            for (Annotation a : this.imf.getAnnotationClass()) {
                String annotation = "";
                annotation = "@WebServiceClient(\n";
                for (Map.Entry<String, String> entry : a.getFields().entrySet()) {
                    if (entry.getKey().equals("serviceName")) {
                        annotation = String.valueOf(annotation) + "\t" + "name" + " = \"" + this.imf.getServiceName() + "\",\n";
                        continue;
                    }
                    if (entry.getKey().equals("wsdlLocation")) {
                        annotation = String.valueOf(annotation) + "\t" + entry.getKey() + " = \"" + this.imf.getWsdlLocation() + "\",\n";
                        continue;
                    }
                    if (!entry.getKey().equals("targetNamespace")) continue;
                    annotation = String.valueOf(annotation) + "\t" + entry.getKey() + " = \"" + this.imf.getTargetNamespace() + "\",\n";
                }
                annotation = String.valueOf(annotation.substring(0, annotation.length() - ",\n".length())) + ")\n";
                writer.write(annotation);
            }
            String endpointNameVariable = String.valueOf(this.imf.getEndpointName().substring(0, 1).toUpperCase()) + this.imf.getEndpointName().substring(1);
            writer.write("public class " + className + " extends Service implements " + "WSOUIService" + "{\n");
            writer.write("\n");
            writer.write("\tpublic final static URL WSDL_LOCATION;\n");
            writer.write("\tpublic final static QName SERVICE = new QName(\"" + this.imf.getTargetNamespace() + "\", \"" + this.imf.getServiceName() + "\");\n");
            writer.write("\tpublic final static QName " + endpointNameVariable + " = new QName(\"" + this.imf.getTargetNamespace() + "\", \"" + this.imf.getServiceName() + "\");\n");
            writer.write("\t\n");
            writer.write("\tstatic {\n");
            writer.write("\t    WSDL_LOCATION = Thread.currentThread().getContextClassLoader().getResource(\"" + this.imf.getWsdlLocation() + "\");\n");
            writer.write("\t}\n");
            writer.write("\tpublic " + className + "() {\n");
            writer.write("\t\tsuper(WSDL_LOCATION, SERVICE);\n");
            writer.write("\t}\n");
            writer.write("\n");
            writer.write("\t@WebEndpoint(name = \"" + this.imf.getEndpointName() + "\")\n");
            writer.write("\tpublic " + this.imf.getInterfaceName() + " get" + endpointNameVariable + "() {\n");
            writer.write("\t    return super.getPort(" + endpointNameVariable + ", " + this.imf.getInterfaceName() + ".class);\n");
            writer.write("\t}\n");
            writer.write("\t\n");
            writer.write("\t\n");
            writer.write("\t@WebEndpoint(name = \"" + this.imf.getEndpointName() + "\")\n");
            writer.write("\tpublic " + this.imf.getInterfaceName() + " getFiremenSOAP(WebServiceFeature... features) {\n");
            writer.write("\t    return super.getPort(" + endpointNameVariable + ", " + this.imf.getInterfaceName() + ".class, features);\n");
            writer.write("\t}\n");
            writer.write("\t\n");
            writer.write("\t\n");
            writer.write("\tpublic URL getWsdlLocation() {\n");
            writer.write("\t    return WSDL_LOCATION;\n");
            writer.write("\t}\n");
            writer.write("\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }
}

