/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.wsdl;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;

public class WSDLJUnitTestGenerator {
    private ImplMetaInf imf;
    private String tns;

    public WSDLJUnitTestGenerator(String tns, ImplMetaInf imf) throws WSOUIException {
        this.imf = imf;
        this.tns = tns;
    }

    public File generate(String basedir) throws IOException {
        String serviceClassName = String.valueOf(this.imf.getServiceName().substring(0, 1).toUpperCase()) + this.imf.getServiceName().substring(1, this.imf.getServiceName().length());
        String className = String.valueOf(serviceClassName) + "WSDLTest";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        File dir = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/") + "/" + className + ".java");
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("import org.junit.Test;\n");
            writer.write("import org.junit.Assert;\n");
            writer.write("import com.ebmwebsourcing.easybox.api.XmlContext;\n");
            writer.write("import com.ebmwebsourcing.easybox.api.XmlContextFactory;\n");
            writer.write("import com.ebmwebsourcing.easybox.api.XmlObjectReader;\n");
            writer.write("import com.ebmwebsourcing.easywsdl11.api.element.Definitions;\n");
            writer.write("\n");
            writer.write("public class " + className + "{\n");
            writer.write("\n");
            writer.write("\t@Test\n");
            writer.write("\tpublic void read" + this.imf.getClassName().replace("Impl", "") + "WsdlTest() throws Exception {\n");
            writer.write("\t\tXmlContextFactory xmlContextFactory = new XmlContextFactory();\n");
            writer.write("\t\tXmlContext xmlContext = xmlContextFactory.newContext();\n");
            writer.write("\t\tXmlObjectReader reader = xmlContext.createReader();\n");
            writer.write("\t\tDefinitions definitions = reader.readDocument(" + serviceClassName + "_WSOUIService" + ".WSDL_LOCATION" + ", Definitions.class);\n");
            writer.write("\t\tAssert.assertNotNull(definitions);\n");
            writer.write("\t\tSystem.out.println(\"wsdl \" + " + serviceClassName + "_WSOUIService" + ".WSDL_LOCATION" + " + \" is validated\");\n");
            writer.write("\t}\n");
            writer.write("\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }
}

