/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.plugin.bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.AnalysorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELAnalyser;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.tools.wsdlto.core.PluginLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.bpel.AssemblyFileCopier;
import org.petalslink.easiestdemo.wsoui.core.bpel.BPELJUnitTestGenerator;
import org.petalslink.easiestdemo.wsoui.core.bpel.BPELProcessGenerator;
import org.petalslink.easiestdemo.wsoui.core.bpel.LoggerFileCopier;
import org.petalslink.easiestdemo.wsoui.core.bpel.SCACompositeDiagramGenerator;
import org.petalslink.easiestdemo.wsoui.core.bpel.SCACompositeGenerator;
import org.petalslink.easiestdemo.wsoui.core.bpel.UnixScriptsGenerator;
import org.petalslink.easiestdemo.wsoui.core.bpel.WindowsScriptsGenerator;
import org.petalslink.easiestdemo.wsoui.plugin.bpel.BpelOption;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.WSDL2JavaGenerateSourcesMojo;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.WsdlOption;

public class BPEL2JavaGenerateSourcesMojo
extends AbstractMojo {
    String sourceRoot = "/src/main/java";
    String testsourceRoot = "/src/test/java";
    String mainresourceRoot = "/src/main/resources";
    String generatedTestSourceRoot = "/target/generated-test-sources/wsoui";
    String generatedSourceRoot = "/target/generated-sources/wsoui";
    URI basedir = new File(".").toURI();
    MavenProject project;
    BpelOption[] bpelOptions;
    boolean generateEndpoint = true;
    BPELValidator validator = null;
    BPELAnalyser analyzer = null;
    File sourceRootFile = null;
    File testsourceRootFile = null;
    File mainresourceRootFile = null;
    File generatedTestSourceRootFile = null;
    File generatedSourceRootFile = null;
    File targetFile = null;
    private boolean compileClass = true;

    public void execute() throws MojoExecutionException {
        if (this.project != null) {
            this.basedir = this.project.getBasedir().toURI();
            this.sourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.sourceRoot));
            this.testsourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.testsourceRoot));
            this.mainresourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.mainresourceRoot));
            this.generatedTestSourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.generatedTestSourceRoot));
            this.generatedSourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.generatedSourceRoot));
            this.targetFile = new File(FileUtil.getURI((URI)this.basedir, (String)"/target"));
        } else {
            this.sourceRootFile = new File(URI.create(String.valueOf(this.basedir.toString()) + this.sourceRoot));
            this.testsourceRootFile = new File(URI.create(String.valueOf(this.basedir.toString()) + this.testsourceRoot));
            this.mainresourceRootFile = new File(URI.create(String.valueOf(this.basedir.toString()) + this.mainresourceRoot));
            this.generatedTestSourceRootFile = new File(URI.create(String.valueOf(this.basedir.toString()) + this.generatedTestSourceRoot));
            this.generatedSourceRootFile = new File(URI.create(String.valueOf(this.basedir.toString()) + this.generatedSourceRoot));
            this.targetFile = new File(URI.create(String.valueOf(this.basedir.toString()) + "/target"));
        }
        List<BpelOption> effectiveBpelOptions = Arrays.asList(this.bpelOptions);
        if (effectiveBpelOptions.size() == 0) {
            this.getLog().info((CharSequence)"Nothing to generate");
            return;
        }
        try {
            try {
                this.validator = new BPELValidator();
                this.analyzer = new BPELAnalyser();
                for (BpelOption o : effectiveBpelOptions) {
                    this.callBpel2Java(o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        finally {
            Bus bus = BusFactory.getDefaultBus((boolean)false);
            if (bus != null) {
                bus.shutdown(true);
            }
            PluginLoader.unload();
        }
        if (this.isCompileClass()) {
            if (this.project != null && this.generatedSourceRootFile != null && this.generatedSourceRootFile.exists()) {
                this.project.addCompileSourceRoot(this.generatedSourceRootFile.getAbsolutePath());
            }
            if (this.project != null && this.generatedTestSourceRootFile != null && this.generatedTestSourceRootFile.exists()) {
                this.project.addTestCompileSourceRoot(this.generatedTestSourceRootFile.getAbsolutePath());
            }
            System.gc();
        }
    }

    private void callBpel2Java(BpelOption bpelOption) throws MojoExecutionException {
        File outputDirFile = this.generatedSourceRootFile;
        outputDirFile.mkdirs();
        if (this.project != null) {
            this.basedir = this.project.getBasedir().toURI();
        }
        try {
            ValidatorResult report = this.validator.validate(bpelOption.getBpelURI(this.basedir).toURL());
            if (report.getErrors().size() > 0) {
                throw new MojoExecutionException(ValidatorResultPrinter.getInstance().printAll(report));
            }
            System.out.println(ValidatorResultPrinter.getInstance().printAll(report));
            AnalysorResult result = this.analyzer.analyze(report.getProcess());
            System.out.println("List of imports in process " + report.getProcess().getName() + " : " + result.getImports());
            ArrayList<URI> excludesWsdl = new ArrayList<URI>();
            for (Interface itf : report.getProcess().getProcessInterfaces()) {
                URI bpelUri = itf.getParentDescription().getDocumentBaseURI();
                excludesWsdl.add(bpelUri);
            }
            ArrayList<WsdlOption> wsdlOptions = new ArrayList<WsdlOption>();
            boolean generate = true;
            for (URI wsdlUri : result.getImports()) {
                generate = true;
                if (wsdlUri.toString().endsWith(".xsd") || this.isContainInList(excludesWsdl, wsdlUri) || !generate) continue;
                WsdlOption wo = new WsdlOption();
                wo.setWsdl(this.createWsdlUrl(wsdlUri.toString(), bpelOption.getBpelURI(this.basedir).toString(), this.basedir.toString()));
                wo.setProvider(true);
                wo.setOverrideOlderBusinessClass(bpelOption.isOverrideOlderBusinessClass());
                wo.setGenerateBusinessClass(bpelOption.isGenerateBusinessClass());
                wsdlOptions.add(wo);
            }
            WSDL2JavaGenerateSourcesMojo wsdlMojo = new WSDL2JavaGenerateSourcesMojo();
            wsdlMojo.setProject(this.project);
            wsdlMojo.setCompileClass(false);
            wsdlMojo.setGeneratedSourceRoot(this.generatedSourceRoot);
            wsdlMojo.setSourceRoot(this.sourceRoot);
            wsdlMojo.setTestsourceRoot(this.testsourceRoot);
            wsdlMojo.setGeneratedTestSourceRoot(this.generatedTestSourceRoot);
            WsdlOption[] opts = wsdlOptions.toArray(new WsdlOption[wsdlOptions.size()]);
            wsdlMojo.setWsdlOptions(opts);
            wsdlMojo.execute();
            this.getLog().info((CharSequence)("Calling bpel2java with process: " + new QName(report.getProcess().getTargetNamespace(), report.getProcess().getName())));
            if (bpelOption.isGenerateBusinessClass()) {
                BPELProcessGenerator bpg = new BPELProcessGenerator(report.getProcess(), wsdlMojo.getAllServerNames(), bpelOption.isOverrideOlderBusinessClass());
                bpg.generate(this.findShortNameOfBPELFile(bpelOption.getBpelURI(this.basedir).toURL().toString(), this.basedir.toString()), this.sourceRootFile.toString(), bpelOption.getEsbFactoryCanonicalName());
                SCACompositeGenerator scg = new SCACompositeGenerator(report.getProcess(), wsdlMojo.getAllMetainfs(), bpelOption.isOverrideOlderBusinessClass());
                scg.generate(this.findShortNameOfBPELFile(bpelOption.getBpelURI(this.basedir).toURL().toString(), this.basedir.toString()), this.sourceRootFile.toString());
                SCACompositeDiagramGenerator scdg = new SCACompositeDiagramGenerator(report.getProcess(), wsdlMojo.getAllMetainfs(), bpelOption.isOverrideOlderBusinessClass());
                scdg.generate(this.findShortNameOfBPELFile(bpelOption.getBpelURI(this.basedir).toURL().toString(), this.basedir.toString()), this.sourceRootFile.toString());
            }
            BPELJUnitTestGenerator bjutg = new BPELJUnitTestGenerator(report.getProcess(), wsdlMojo.getAllServerNames());
            bjutg.generate(this.findShortNameOfBPELFile(bpelOption.getBpelURI(this.basedir).toURL().toString(), this.basedir.toString()), this.testsourceRootFile.toString());
            AssemblyFileCopier assemblyCopy = new AssemblyFileCopier(this.targetFile);
            assemblyCopy.copyAssemblyFile();
            LoggerFileCopier loggerCopyTarget = new LoggerFileCopier(this.targetFile);
            loggerCopyTarget.copyLoggerFile();
            LoggerFileCopier loggerCopySrc = new LoggerFileCopier(this.mainresourceRootFile);
            loggerCopySrc.copyLoggerFile();
            String projectName = null;
            String version = null;
            if (this.project != null) {
                projectName = this.project.getArtifactId();
                version = this.project.getVersion();
            }
            WindowsScriptsGenerator wsg = new WindowsScriptsGenerator(projectName, version, report.getProcess(), wsdlMojo.getAllServerNames(), bpelOption.isOverrideOlderBusinessClass());
            wsg.generateAllScripts(this.targetFile.toString());
            UnixScriptsGenerator usg = new UnixScriptsGenerator(projectName, version, report.getProcess(), wsdlMojo.getAllServerNames(), bpelOption.isOverrideOlderBusinessClass());
            usg.generateAllScripts(this.targetFile.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (BPELException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (WSOUIException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private boolean isContainInList(List<URI> excludesWsdl, URI wsdlUri) {
        boolean res = false;
        for (URI uri : excludesWsdl) {
            if (!uri.toString().endsWith(wsdlUri.toString())) continue;
            res = true;
            break;
        }
        return res;
    }

    private String createWsdlUrl(String wsdlUri, String bpelUri, String basedir) {
        if (basedir.endsWith("./")) {
            basedir.substring(0, basedir.length() - "./".length());
        }
        String relativePath = bpelUri.replace(basedir, "");
        String path = String.valueOf(relativePath.substring(0, relativePath.lastIndexOf("/") + 1)) + wsdlUri;
        return path;
    }

    private String findShortNameOfBPELFile(String bpelUri, String basedir) {
        if (basedir.endsWith("./")) {
            basedir = basedir.substring(0, basedir.length() - "./".length());
        }
        String path = bpelUri.replace(basedir, "");
        path = path.replace("src/main/resources/", "");
        path = path.replace("src/test/resources/", "");
        path = path.replace("target/test-classes/", "");
        path = path.replace("target/classes/", "");
        return path;
    }

    public BpelOption[] getBpelOptions() {
        return this.bpelOptions;
    }

    public void setBpelOptions(BpelOption[] bpelOptions) {
        this.bpelOptions = bpelOptions;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public String getTestsourceRoot() {
        return this.testsourceRoot;
    }

    public void setTestsourceRoot(String testsourceRoot) {
        this.testsourceRoot = testsourceRoot;
    }

    public String getGeneratedTestSourceRoot() {
        return this.generatedTestSourceRoot;
    }

    public void setGeneratedTestSourceRoot(String generatedTestSourceRoot) {
        this.generatedTestSourceRoot = generatedTestSourceRoot;
    }

    public String getGeneratedSourceRoot() {
        return this.generatedSourceRoot;
    }

    public void setGeneratedSourceRoot(String generatedSourceRoot) {
        this.generatedSourceRoot = generatedSourceRoot;
    }

    public boolean isGenerateEndpoint() {
        return this.generateEndpoint;
    }

    public void setGenerateEndpoint(boolean generateEndpoint) {
        this.generateEndpoint = generateEndpoint;
    }

    public boolean isCompileClass() {
        return this.compileClass;
    }

    public void setCompileClass(boolean compileClass) {
        this.compileClass = compileClass;
    }
}

