package org.petalslink.easiestdemo.wsoui.provided;

import java.net.URL;

public class ProviderConfiguration {
	
	public static PositionType DEFAULT_POSITION = PositionType.NORTH_WEST;
	
	public enum PositionType { NORTH_EAST("NE"), NORTH_WEST("NW"), SOUTH_EAST("SE"), SOUTH_WEST("SW");	
		String pos = null;		
		PositionType(String pos) {
			this.pos = pos;
		}		
		
		String getPosition() {
			return this.pos;
		}
		
		static public PositionType getPositionTypeFromString(String value) {
			if(NORTH_EAST.pos.equals(value)) {
				return NORTH_EAST;
			} else if(NORTH_WEST.pos.equals(value)) {
				return NORTH_WEST;
			} else if(SOUTH_EAST.pos.equals(value)) {
				return SOUTH_EAST;
			} else {
				return SOUTH_WEST;
			}
		}
	}
	
	private PositionType position = ProviderConfiguration.DEFAULT_POSITION;
	
	private URL image = null;
	
	private String endpointAddress = null;

	private boolean activeGui = false;
	


	public boolean isActiveGui() {
		return activeGui;
	}

	public void setActiveGui(boolean activeGui) {
		this.activeGui = activeGui;
	}

	public String getEndpointAddress() {
		return endpointAddress;
	}

	public void setEndpointAddress(String endpointAddress) {
		this.endpointAddress = endpointAddress;
	}


	public PositionType getPosition() {
		return position;
	}

	public void setPosition(PositionType position) {
		this.position = position;
	}


	public URL getImage() {
		return image;
	}

	public void setImage(URL image) {
		this.image = image;
	}
	


	@Override
	public String toString() {
		return "ProviderConfiguration [position=" + position + ", image="
				+ image + ", endpointAddress=" + endpointAddress + "]";
	}


	
}
