package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.Provider;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class ServerGenerator {

	private ImplMetaInf imf;

	private boolean override = false;

	private Provider provider;

	private String clazz; 

	private boolean activeGUI;

	private String tns;


	public ServerGenerator(String tns, ImplMetaInf imf, Provider provider, boolean activeGUI,  boolean override) throws WSOUIException {
		this.imf = imf;
		this.provider = provider;
		this.override = override;
		this.activeGUI = activeGUI;
		this.tns = tns;
	}
	
	
	
	public String deduceClassName(String basedir) {
		String serviceClassName = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length());
		String className = serviceClassName + "_WSOUIServer";
		String packageName = FileUtil.createPackageNameFromTargetNamespace(tns);
		return packageName + "." + className;
	}


	public File generate(String basedir) throws IOException {

		String serviceClassName = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length());
		String className = serviceClassName + "_WSOUIServer";
		String packageName = FileUtil.createPackageNameFromTargetNamespace(tns);
		this.clazz = packageName + "." + className;
		
		File dir = new File(basedir + "/" + packageName.replace(".", "/"));
		if(!dir.exists()) {
			dir.mkdirs();
		}
		File f = FileUtil.createFile(className, packageName, basedir, ".java", this.override);
		//	File f = new File(basedir + "/" + packageName.replace(".", "/") + "/"+ className + ".java");

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + packageName + ";\n");
			writer.write("\n");

			// create imports
			writer.write("import " + packageName + "." + serviceClassName + "_ExchangeProcessor" + ";\n");
			writer.write("import " + packageName + "." + serviceClassName + "ImplementationManager" + ";\n");
			writer.write("import " + packageName + "." + serviceClassName + "TestImplementation" + ";\n");
			writer.write("import " + packageName + "." + serviceClassName + "_WSOUIService" + ";\n");
			writer.write("import javax.xml.ws.Endpoint;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
			writer.write("import org.petalslink.abslayer.service.api.Description;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
			writer.write("\n");

			// create class
			writer.write("public class " + className + " {\n");
			writer.write("\n");

			// create variable
			// generate endpoint
			writer.write("\tprivate Endpoint endpointFor_" + serviceClassName + " = null;\n");
			writer.write("\tprivate ProviderConfiguration confEndpointFor_" + serviceClassName + " = null;\n");
			writer.write("\tprivate AbstractImplementationManager<?> im = null;\n");

			writer.write("\t\n");

			// create constructor
			writer.write("\tpublic " + className + "() {\n");
			writer.write("\t}\n");
			writer.write("\n\n");

			// create configuration provider methods
			// generate create provider configuration method
			writer.write("\tpublic ProviderConfiguration createDefaultProviderConfigurationFor_" + serviceClassName + "() {\n");
			writer.write(this.generateConfigurationProviderMethod(this.provider));
			writer.write("\t}\n");
			writer.write("\n\n");

			// generate get provider configuration method
			writer.write("\tpublic ProviderConfiguration getProviderConfigurationFor_" + serviceClassName + "() {\n");
			writer.write("\t\tif(this.confEndpointFor_" + serviceClassName + " == null) {\n");
			writer.write("\t\t\tthis.confEndpointFor_" + serviceClassName + " = createDefaultProviderConfigurationFor_" + serviceClassName + "();\n");
			writer.write("\t\t}\n");
			writer.write("\t\treturn this.confEndpointFor_" + serviceClassName + ";\n");
			writer.write("\t}\n");
			writer.write("\n\n");

			// create stop method
			writer.write("\tpublic void start() throws WSOUIException {\n");
			writer.write("\t\tconfEndpointFor_" + serviceClassName + " = getProviderConfigurationFor_" + serviceClassName + "();\n");
			writer.write("\t\tim = new " + serviceClassName + "ImplementationManager" + "(new " + serviceClassName + "TestImplementation" + "(new " + serviceClassName + "_ExchangeProcessor" + "()" + "), " + serviceClassName + "_WSOUIService.WSDL_LOCATION" + ", confEndpointFor_" + serviceClassName + ");\n");
			writer.write("\t\tendpointFor_" + serviceClassName + " = Endpoint.publish(" + "confEndpointFor_" + serviceClassName + ".getEndpointAddress()" + ", im);\n");
			writer.write("\t\tSystem.out.println(\"Service deploy at: \" + confEndpointFor_" + serviceClassName + ".getEndpointAddress()" + " + \"?wsdl\");\n"); 
			writer.write("\t\tSystem.out.println(\"Service Configuration: \" + confEndpointFor_" + serviceClassName + ");\n"); 
			writer.write("\t}\n");
			writer.write("\n\n");


			// create stop method
			writer.write("\tpublic void stop() {\n");
			// generate stop
			writer.write("\t\tif(endpointFor_" + serviceClassName + " != null) {\n");
			writer.write("\t\t\tendpointFor_" + serviceClassName + ".stop();\n");
			writer.write("\t\t}\n");
			writer.write("\t}\n");
			writer.write("\n\n");

			// create getDescription method
			writer.write("\tpublic Description getDescription() {\n");
			writer.write("\t\treturn im.getDescription();\n");
			writer.write("\t}\n");
			writer.write("\n\n");

			// create main methods
			writer.write("\tpublic static void main(String args[]) throws Exception {\n");
			writer.write("\t\t" + className + " provider = new " + className + "();\n");
			writer.write("\t\tprovider.start();\n");
			writer.write("\t\tprovider.getProviderConfigurationFor_" + serviceClassName + "().setActiveGui(true);\n");
			writer.write("\t\tSystem.out.println(\"Server ready...\");\n"); 
			writer.write("\t}\n");

			writer.write("\n");
			writer.write("}\n");
		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}




	private String generateConfigurationProviderMethod(
			Provider conf) {
		String res = "" +
		"\t\tProviderConfiguration conf = new ProviderConfiguration();\n" ;
		if(this.provider != null && this.provider.getEndpointAddress() != null) {
			res = res + "\t\tconf.setEndpointAddress(\"" + this.provider.getEndpointAddress() + "\");\n";
		} else {
			res = res + "\t\tconf.setEndpointAddress(\"" + "CHANGE ME..." + "\");\n";
		}
		if(conf.getImage() != null) {
			res = res + "\t\tconf.setImage(" + "Thread.currentThread().getContextClassLoader().getResource(\"" + conf.getImage() + "\"));\n";
		}
		res = res +
		"\t\tconf.setPosition(" + "PositionType."  + conf.getPosition() + ");\n" +
		"\t\tconf.setActiveGui(" + this.activeGUI + ");\n" +
		"\t\treturn conf;\n"; 
		return res;
	}

	public String getClassName() {
		return clazz;
	}
	
}
