package org.petalslink.easiestdemo.wsoui.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easierbsm.BSMFactoryImpl;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbFault;
import easyesb.petalslink.com.data.admin._1.StoreBpel;
import easyesb.petalslink.com.data.admin._1.StoreBpelResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;

public final class ESBManagement {

	private static ESBManagement esbManagement = new ESBManagement();

	private ESBFactory esbFactory = new ESBFactoryImpl();

	private ESBFactory monitoringFactory = new BSMFactoryImpl();


	public static ESBManagement getInstance(){
		return ESBManagement.esbManagement;
	}

	private ESBManagement(){

	}

	public void setESBFactory(ESBFactory factory){
		esbFactory = factory;
	}

	public ESBFactory getESBFactory(){
		return esbFactory;
	}
	
	public void setMonitoringFactory(ESBFactory factory){
		monitoringFactory = factory;
	}

	public ESBFactory getMonitoringFactory(){
		return monitoringFactory;
	}


	public Node createBSMNode(final QName name, final String host, final int port, final int soap_port) throws ESBException {
		ESBFactory factory = new BSMFactoryImpl("creation-resources-service-factory", "rawreport-service-factory");
		Node node = factory.createNode(name, new ConfigurationImpl(host, port, new HashMap<String, String>() {{ put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));}}));
		return node;
	}

	public Node createNode(final QName name, final String host, final int port, final int soap_port) throws ESBException {
		ESBFactory factory = new ESBFactoryImpl("data-collector-factory", "wsdm-monitoring-factory", "sla-manager-factory");
		Node node = factory.createNode(name, new ConfigurationImpl(host, port, new HashMap<String, String>() {{ put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));}}));
		return node;
	}


	public List<URL> deployAndExposeBPEL(URL bpel, URL nodeUrl) throws ManagementException {
		List<URL> res = new ArrayList<URL>();
		try {
			// create payload request
			StoreBpel payload = new StoreBpel();
			StoreBpelResponse storeBpelReponse = null;

			// store bpel 
			payload.setBpelUrl(bpel.toString());
			storeBpelReponse = ESBManagement.storeBpel(payload, nodeUrl.toString());

			for(String url: storeBpelReponse.getBpelEndpointAddress()) {
				res.add(new URL(url));
			}
		} catch (MalformedURLException e) {
			throw new ManagementException(e.getMessage(), e);
		}
		return res;
	}

	private static StoreBpelResponse storeBpel(StoreBpel payload, String address) throws ManagementException {
		SOAPSender sender = new SOAPSender();
		SOAPHandler soapHandler = new SOAPHandler();
		StoreBpelResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = sender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/storeBpel");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true));
				EJaxbFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new ManagementException("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild(doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, StoreBpelResponse.class);
		} catch (JDOMException e) {
			throw new ManagementException("Technical Fault");
		} catch (SOAException e) {
			throw new ManagementException("Technical Fault");
		} catch (SOAPException e) {
			throw new ManagementException("Technical Fault");
		} catch (ParserConfigurationException e) {
			throw new ManagementException("Technical Fault");
		}
		return response;
	}
}
