/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.wsdl;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.Provider;

public class ServerGenerator {
    private ImplMetaInf imf;
    private boolean override = false;
    private Provider provider;
    private String clazz;
    private boolean activeGUI;
    private String tns;

    public ServerGenerator(String tns, ImplMetaInf imf, Provider provider, boolean activeGUI, boolean override) throws WSOUIException {
        this.imf = imf;
        this.provider = provider;
        this.override = override;
        this.activeGUI = activeGUI;
        this.tns = tns;
    }

    public String deduceClassName(String basedir) {
        String serviceClassName = this.imf.getServiceName().substring(0, 1).toUpperCase() + this.imf.getServiceName().substring(1, this.imf.getServiceName().length());
        String className = serviceClassName + "_WSOUIServer";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        return packageName + "." + className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate(String basedir) throws IOException {
        String serviceClassName = this.imf.getServiceName().substring(0, 1).toUpperCase() + this.imf.getServiceName().substring(1, this.imf.getServiceName().length());
        String className = serviceClassName + "_WSOUIServer";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        this.clazz = packageName + "." + className;
        File dir = new File(basedir + "/" + packageName.replace(".", "/"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = FileUtil.createFile((String)className, (String)packageName, (String)basedir, (String)".java", (boolean)this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("import " + packageName + "." + serviceClassName + "_ExchangeProcessor" + ";\n");
            writer.write("import " + packageName + "." + serviceClassName + "ImplementationManager" + ";\n");
            writer.write("import " + packageName + "." + serviceClassName + "TestImplementation" + ";\n");
            writer.write("import " + packageName + "." + serviceClassName + "_WSOUIService" + ";\n");
            writer.write("import javax.xml.ws.Endpoint;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import org.petalslink.abslayer.service.api.Description;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
            writer.write("\n");
            writer.write("public class " + className + " {\n");
            writer.write("\n");
            writer.write("\tprivate Endpoint endpointFor_" + serviceClassName + " = null;\n");
            writer.write("\tprivate ProviderConfiguration confEndpointFor_" + serviceClassName + " = null;\n");
            writer.write("\tprivate AbstractImplementationManager<?> im = null;\n");
            writer.write("\t\n");
            writer.write("\tpublic " + className + "() {\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\tpublic ProviderConfiguration createDefaultProviderConfigurationFor_" + serviceClassName + "() {\n");
            writer.write(this.generateConfigurationProviderMethod(this.provider));
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\tpublic ProviderConfiguration getProviderConfigurationFor_" + serviceClassName + "() {\n");
            writer.write("\t\tif(this.confEndpointFor_" + serviceClassName + " == null) {\n");
            writer.write("\t\t\tthis.confEndpointFor_" + serviceClassName + " = createDefaultProviderConfigurationFor_" + serviceClassName + "();\n");
            writer.write("\t\t}\n");
            writer.write("\t\treturn this.confEndpointFor_" + serviceClassName + ";\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\tpublic void start() throws WSOUIException {\n");
            writer.write("\t\tconfEndpointFor_" + serviceClassName + " = getProviderConfigurationFor_" + serviceClassName + "();\n");
            writer.write("\t\tim = new " + serviceClassName + "ImplementationManager" + "(new " + serviceClassName + "TestImplementation" + "(new " + serviceClassName + "_ExchangeProcessor" + "()" + "), " + serviceClassName + "_WSOUIService.WSDL_LOCATION" + ", confEndpointFor_" + serviceClassName + ");\n");
            writer.write("\t\tendpointFor_" + serviceClassName + " = Endpoint.publish(" + "confEndpointFor_" + serviceClassName + ".getEndpointAddress()" + ", im);\n");
            writer.write("\t\tSystem.out.println(\"Service deploy at: \" + confEndpointFor_" + serviceClassName + ".getEndpointAddress()" + " + \"?wsdl\");\n");
            writer.write("\t\tSystem.out.println(\"Service Configuration: \" + confEndpointFor_" + serviceClassName + ");\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\tpublic void stop() {\n");
            writer.write("\t\tif(endpointFor_" + serviceClassName + " != null) {\n");
            writer.write("\t\t\tendpointFor_" + serviceClassName + ".stop();\n");
            writer.write("\t\t}\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\tpublic Description getDescription() {\n");
            writer.write("\t\treturn im.getDescription();\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\tpublic static void main(String args[]) throws Exception {\n");
            writer.write("\t\t" + className + " provider = new " + className + "();\n");
            writer.write("\t\tprovider.start();\n");
            writer.write("\t\tprovider.getProviderConfigurationFor_" + serviceClassName + "().setActiveGui(true);\n");
            writer.write("\t\tSystem.out.println(\"Server ready...\");\n");
            writer.write("\t}\n");
            writer.write("\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    private String generateConfigurationProviderMethod(Provider conf) {
        String res = "\t\tProviderConfiguration conf = new ProviderConfiguration();\n";
        res = this.provider != null && this.provider.getEndpointAddress() != null ? res + "\t\tconf.setEndpointAddress(\"" + this.provider.getEndpointAddress() + "\");\n" : res + "\t\tconf.setEndpointAddress(\"" + "CHANGE ME..." + "\");\n";
        if (conf.getImage() != null) {
            res = res + "\t\tconf.setImage(" + "Thread.currentThread().getContextClassLoader().getResource(\"" + conf.getImage() + "\"));\n";
        }
        res = res + "\t\tconf.setPosition(" + "PositionType." + (Object)((Object)conf.getPosition()) + ");\n" + "\t\tconf.setActiveGui(" + this.activeGUI + ");\n" + "\t\treturn conf;\n";
        return res;
    }

    public String getClassName() {
        return this.clazz;
    }
}

