package org.petalslink.easiestdemo.wsoui.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.BSMFactoryImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbBpelReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import esstar.petalslink.com.service.management.user._1_0.UserManagement;

public final class ESBManagement {

	private static ESBManagement esbManagement = new ESBManagement();

	private ESBFactory esbFactory = new ESBFactoryImpl();

	private ESBFactory monitoringFactory = new BSMFactoryImpl();


	public static ESBManagement getInstance(){
		return ESBManagement.esbManagement;
	}

	private ESBManagement(){

	}

	public void setESBFactory(ESBFactory factory){
		esbFactory = factory;
	}

	public ESBFactory getESBFactory(){
		return esbFactory;
	}
	
	public void setMonitoringFactory(ESBFactory factory){
		monitoringFactory = factory;
	}

	public ESBFactory getMonitoringFactory(){
		return monitoringFactory;
	}


	public Node createBSMNode(final QName name, final String host, final int port, final int soap_port) throws ESBException {
		ESBFactory factory = new BSMFactoryImpl("creation-resources-service-factory", "rawreport-service-factory");
		Node node = factory.createNode(name, new ConfigurationImpl(host, port, new HashMap<String, String>() {{ put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));}}));
		return node;
	}

	public Node createNode(final QName name, final String host, final int port, final int soap_port) throws ESBException {
		ESBFactory factory = new ESBFactoryImpl("data-collector-factory", "wsdm-monitoring-factory", "sla-manager-factory");
		Node node = factory.createNode(name, new ConfigurationImpl(host, port, new HashMap<String, String>() {{ put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));}}));
		return node;
	}


	public List<URL> deployAndExposeBPEL(URL bpel, URL nodeUrl) throws ManagementException {
		List<URL> res = new ArrayList<URL>();
		try {
			// create payload request
			EJaxbDeploy payload = new EJaxbDeploy();
			EJaxbDescriptorType main = new EJaxbDescriptorType();
			main.setFileURI(bpel.toString());
			payload.setMainResource(main);
			
			UserManagement client = new UserManagementClientSOAP(nodeUrl.toString());
			EJaxbDeployResponse response = client.deploy(payload);
			EJaxbBpelReport report = (EJaxbBpelReport) response.getDeployementReport().getAny();
	
			for(String url: report.getExternalEndpointsAddressesCreated()) {
				res.add(new URL(url));
			}
		} catch (MalformedURLException e) {
			throw new ManagementException(e.getMessage(), e);
		}
		return res;
	}

}
