package org.petalslink.easiestdemo.wsoui.core.bpel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;

public class AssemblyFileCopier {

	private static final String ASSEMBLY = "assembly";
	private static final String ASSEMBLY_RUNTIME_XML = "assembly/runtime.xml";
	private static final String ASSEMBLY_DEV_XML = "assembly/dev.xml";
	
	private static final String ASSEMBLY_RSC_XML = "assembly/rsc.xml";
	private static final String ASSEMBLY_ZIP_XML = "assembly/zip.xml";
	private File target;
	
	
	public AssemblyFileCopier(File target) {
		this.target = target;
	}
	
	public void copyAssemblyFile() throws IOException {
		InputStream devIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_DEV_XML);
		InputStream runtimeIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_RUNTIME_XML);

		InputStream zipIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_ZIP_XML);
		InputStream rscIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(ASSEMBLY_RSC_XML);

		
		File assemblyDir = new File(target + "/" + ASSEMBLY);
		assemblyDir.mkdirs();
		File devFile = new File(target + "/" + ASSEMBLY_DEV_XML);
		File runtimeFile = new File(target + "/" + ASSEMBLY_RUNTIME_XML);
		devFile.createNewFile();
		runtimeFile.createNewFile();
		
		OutputStream devOut = new FileOutputStream(devFile);
		OutputStream runtimeOut = new FileOutputStream(runtimeFile);
		
		FileUtil.copy(devIn, devOut);
		FileUtil.copy(runtimeIn, runtimeOut);
		
		devIn.close();
		runtimeIn.close();
		devOut.close();
		runtimeOut.close();
		
		
		File zipFile = new File(target + "/" + ASSEMBLY_ZIP_XML);
		File rscFile = new File(target + "/" + ASSEMBLY_RSC_XML);
		zipFile.createNewFile();
		rscFile.createNewFile();
		
		OutputStream zipOut = new FileOutputStream(zipFile);
		OutputStream rscOut = new FileOutputStream(rscFile);
		
		FileUtil.copy(zipIn, zipOut);
		FileUtil.copy(rscIn, rscOut);
		
		zipIn.close();
		rscIn.close();
		zipOut.close();
		rscOut.close();
	}
}
