package org.petalslink.easiestdemo.wsoui.provided.notification;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WSNUtil;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.SubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;

public class SubscriptionManager {

	private URL topicSetURL = null;

	private Document topicSetDoc = null;

	private URL topicNamespaceURL = null;

	private TopicNamespaceType topicNamespace = null;

	public static Map<String, EJaxbSubscribe> clients = new HashMap<String, EJaxbSubscribe>();


	public SubscriptionManager() {
	}


	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribe) throws WsnbException {
		EJaxbSubscribeResponse res = null;
		String clientAddress = subscribe.getConsumerReference().getAddress().getValue().toString();
		System.out.println("************************ clientAddress = " + clientAddress);
		if(clientAddress != null && clientAddress.trim().length() > 0) {
			clients.put(clientAddress, subscribe);
		} else {
			throw new WsnbException("ConsumerReference address in the subcribe cannot be null!!!");
		}
		System.out.println("************************ clients: " + clients);
		EndpointReferenceType epr = WSNUtil.getInstance().getXmlObjectFactory().wrap(subscribe.getConsumerReference(), EndpointReferenceType.class);
		res = ((SubscribeResponseImpl)RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createSubscribeResponse(epr)).getJaxbTypeObj();
		return res;
	}

	public List<String> getInterestedClientByEvent(Document doc) {
		// TODO : find interested client by event
		return new ArrayList<String>(clients.keySet());
	}

	public URL getTopicSetURL() {
		return topicSetURL;
	}

	public void setTopicSet(URL topicSet) throws WSOUIException {
		if(topicSet == null) {
			throw new WSOUIException("topicSet cannot be null!!!");
		}
		this.topicSetURL = topicSet;
		try {
			InputStream is = topicSet.openStream();
			this.topicSetDoc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
			is.close();
		} catch (SAXException e) {
			throw new WSOUIException(e);
		} catch (IOException e) {
			throw new WSOUIException(e);
		} catch (ParserConfigurationException e) {
			throw new WSOUIException(e);
		}
	}

	public Document getTopicSetDocument() {
		return topicSetDoc;
	}


	public URL getTopicNamespaceURL() {
		return topicSetURL;
	}

	public void setTopicNamespace(URL topicNs) throws WSOUIException {
		this.topicNamespaceURL = topicNs;
		try {
			if(this.topicNamespaceURL != null) {
				InputStream is = topicNamespaceURL.openStream();
				Document topicNamespaceDoc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
				is.close();
				topicNamespace = RefinedWstopFactory.getInstance(new WstopModelFactoryImpl()).getWstopReader().readTopicNamespaceType(topicNamespaceDoc);
			}
		} catch (SAXException e) {
			throw new WSOUIException(e);
		} catch (IOException e) {
			throw new WSOUIException(e);
		} catch (ParserConfigurationException e) {
			throw new WSOUIException(e);
		} catch (WstopException e) {
			throw new WSOUIException(e);
		}
	}

	public TopicNamespaceType getTopicNamespace() {
		return this.topicNamespace;
	}

}
