/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.provided.notification;

import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import java.net.URI;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.JDOMException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.petalslink.easiestdemo.wsoui.provided.notification.NotificationBeforeProcessingRequestThread;
import org.petalslink.easiestdemo.wsoui.provided.notification.NotificationBeforeSendResponseThread;
import org.petalslink.easiestdemo.wsoui.provided.notification.SubscriptionManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractEventProducerNotifier
implements Runnable {
    private static Logger LOG = Logger.getLogger(AbstractEventProducerNotifier.class.getName());
    public static final int DEFAULT_THREAD_COUNTER = 1;
    private SubscriptionManager subscriptionManager = null;
    private int periodEvent = 0;
    private SOAPSender sender = new SOAPSender();
    private WSOUIJaxbContextItf context = null;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private ProviderConfiguration configuration;

    public AbstractEventProducerNotifier(ProviderConfiguration configuration, WSOUIJaxbContextItf context) {
        this.subscriptionManager = new SubscriptionManager();
        this.context = context;
        this.configuration = configuration;
        this.setPeriodEvent();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        if (this.periodEvent > 0) {
            this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(this, 0L, this.periodEvent, TimeUnit.MILLISECONDS);
        }
    }

    public int getPeriodEvent() {
        return this.periodEvent;
    }

    public void setPeriodEvent(int periodEvent) {
        this.periodEvent = periodEvent;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public String getProducerAddress() {
        return this.configuration.getEndpointAddress();
    }

    public void sendEventBeforeProcessingRequest(String methodName, Object request) {
        NotificationBeforeProcessingRequestThread sender = new NotificationBeforeProcessingRequestThread(this, methodName, request);
        sender.start();
    }

    public void sendEventBeforeSendResponse(String methodName, Object request, Object response) {
        NotificationBeforeSendResponseThread sender = new NotificationBeforeSendResponseThread(this, methodName, request, response);
        sender.start();
    }

    public abstract void setPeriodEvent();

    public abstract AbstractJaxbModelObject createPeriodicallyEvent() throws WSOUIException;

    public abstract AbstractJaxbModelObject createEventBeforeProcessingRequest(String var1, Object var2) throws WSOUIException;

    public abstract AbstractJaxbModelObject createEventBeforeSendResponse(String var1, Object var2, Object var3) throws WSOUIException;

    @Override
    public void run() {
        try {
            AbstractJaxbModelObject event = this.createPeriodicallyEvent();
            this.sendEvent(event);
        }
        catch (ESBException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (WSOUIException e) {
            e.printStackTrace();
        }
    }

    public void sendEvent(AbstractJaxbModelObject event) throws ESBException, SOAPException {
        try {
            if (event != null) {
                Document doc = this.context.marshallAnyElement(event);
                NotificationMessageHolderType.Message msg = RefinedWsnbFactory.getInstance((WsnbModelFactory)new WsnbModelFactoryImpl()).createNotificationMessageHolderTypeMessage(doc.getDocumentElement());
                NotificationMessageHolderType nmh = RefinedWsnbFactory.getInstance((WsnbModelFactory)new WsnbModelFactoryImpl()).createNotificationMessageHolderType(msg);
                EndpointReferenceType producerEpr = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
                Address producerAddress = (Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
                producerAddress.setValue(URI.create(this.getProducerAddress()));
                producerEpr.setAddress(producerAddress);
                nmh.setProducerReference(producerEpr);
                Notify notify = RefinedWsnbFactory.getInstance((WsnbModelFactory)new WsnbModelFactoryImpl()).createNotify(nmh);
                QName elmtQn = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
                LOG.finest("elmtQn = " + elmtQn);
                TopicExpressionType topic = this.findCorrespondingTopic(elmtQn);
                if (topic != null) {
                    nmh.setTopic(topic);
                }
                LOG.finest("topic = " + topic);
                Document emissionDate = this.createEmissionDate();
                notify.getAny().add(emissionDate.getDocumentElement());
                List<String> interestedClients = this.subscriptionManager.getInterestedClientByEvent(doc, topic);
                LOG.finest("List of interested clients: " + interestedClients);
                for (String client : interestedClients) {
                    EndpointReferenceType subscriberEpr = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
                    Address subscriberAddress = (Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
                    subscriberAddress.setValue(URI.create(client));
                    subscriberEpr.setAddress(subscriberAddress);
                    nmh.setSubscriptionReference(subscriberEpr);
                    doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                    if (topic != null) {
                        EJaxbNotify not = (EJaxbNotify)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbNotify.class);
                        QName topicQn = this.findCorrespondingTopicQName(elmtQn);
                        LOG.finest("topicQn = " + topicQn);
                        doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)not);
                    }
                    LOG.finest("Send notification to " + client);
                    Document soapRequest = SOAPSender.createSOAPMessageRequest((Document)doc);
                    System.out.println("Notif sent by ws provider: \n" + XMLPrettyPrinter.prettyPrint((Document)soapRequest));
                    this.sender.sendSoapRequest(soapRequest, client, null);
                }
            }
        }
        catch (WSOUIException e) {
            throw new ESBException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new ESBException((Throwable)e);
        }
        catch (WstopException e) {
            throw new ESBException((Throwable)e);
        }
        catch (WsnbException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SOAException e) {
            throw new ESBException((Throwable)e);
        }
    }

    private TopicExpressionType findCorrespondingTopic(QName qName) throws WstopException, WsnbException {
        TopicExpressionType notifyTopicExpr = null;
        TopicNamespaceType topicNamespace = this.subscriptionManager.getTopicNamespace();
        LOG.finest("llllllllllllllllllllllllllllllll qName = " + qName);
        LOG.finest("llllllllllllllllllllllllllllllll topicNamespace = " + topicNamespace);
        if (topicNamespace != null) {
            for (TopicNamespaceType.Topic t : topicNamespace.getTopics()) {
                for (QName topicUsed : t.getMessageTypes()) {
                    LOG.finest("llllllllllllllllllllllllllllllll topicUsed = " + topicUsed);
                    if (!topicUsed.equals(qName)) continue;
                    notifyTopicExpr = WSNHelper.createSimpleTopicExpression((QName)new QName(topicNamespace.getNamespace().toString(), t.getName(), "top"), (String)URI.create("http://www.w3.org/TR/1999/REC-xpath-19991116").toString());
                    return notifyTopicExpr;
                }
            }
            LOG.warning("Impossible to find topic corresponding to this element \"" + qName + "\" in this topicnamespace: " + topicNamespace.getNamespace());
        }
        return null;
    }

    private QName findCorrespondingTopicQName(QName qName) throws WstopException {
        QName res = null;
        TopicNamespaceType topicNamespace = this.subscriptionManager.getTopicNamespace();
        if (topicNamespace != null) {
            for (TopicNamespaceType.Topic t : topicNamespace.getTopics()) {
                for (QName topicUsed : t.getMessageTypes()) {
                    if (!topicUsed.equals(qName)) continue;
                    res = new QName(topicNamespace.getNamespace().toString(), t.getName(), "top");
                    return res;
                }
            }
            LOG.warning("Impossible to find topic corresponding to this element \"" + qName + "\" in this topicnamespace: " + topicNamespace.getNamespace());
        }
        return null;
    }

    private Document createEmissionDate() throws WSOUIException {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            Element emissionDate = doc.createElementNS("http://wwww.petalslink.com/wsoui/wsnotification", "emissionDate");
            emissionDate.setPrefix("ebm");
            emissionDate.setNodeValue(DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)GregorianCalendar.getInstance()).toString());
            doc.appendChild(emissionDate);
        }
        catch (ParserConfigurationException e) {
            throw new WSOUIException(e);
        }
        catch (DOMException e) {
            throw new WSOUIException(e);
        }
        catch (DatatypeConfigurationException e) {
            throw new WSOUIException(e);
        }
        return doc;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

