package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;


public class WSOUIJaxbContextGenerator {

	private List<File> objectFactories;

	public WSOUIJaxbContextGenerator(List<File> objectFactories) {
		this.objectFactories = objectFactories;
	}


	public File generate(String basedir) throws IOException {
		String packageName = "org.petalslink.wsoui.context";
		String className = "WSOUIJaxbContext";
		
		File dir = new File(basedir + "/" + packageName.replace(".", "/"));
		if(!dir.exists()) {
			dir.mkdirs();
		}
		
		File f = new File(basedir + "/" + packageName.replace(".", "/") + "/" + className + ".java");

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + packageName + ";\n");
			writer.write("\n");

			// add specific import
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.util.AbstractSOAJAXBContext;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
			writer.write("\n");

			// create class
			writer.write("public class " + className + " extends AbstractSOAJAXBContext implements WSOUIJaxbContextItf {\n");
			writer.write("\n");
			
			// create constructor
			writer.write("\tpublic " + className + "() throws WSOUIException {\n");
			writer.write("\t\tsuper();\n");
			writer.write("\t\tthis.addOtherObjectFactory(" + createListOfObjectFactories(basedir) + ");\n");
			writer.write("\t}\n");
			writer.write("\n");
			
			
			writer.write("}\n");



		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}


	private String createListOfObjectFactories(String basedir) {
		String res = "";
		for(File f: this.objectFactories) {
			String className = f.getAbsolutePath().substring(f.getAbsolutePath().indexOf(basedir) + basedir.length() + 1).replace("/", ".").replace("\\", ".");
			className = className.substring(0, className.length() - ".java".length()) + ".class";
			res = res + className + ", ";
		}
		
		// add ws-notification object factories
		res = res + "easybox.org.oasis_open.docs.wsrf.rp_2.ObjectFactory.class, ";
		res = res + "easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class, ";

		
		return res.substring(0, res.length() - ", ".length());
	}
}
