package org.petalslink.easiestdemo.sdk.core;


import java.io.File;
import java.io.FileWriter;
import java.io.IOException;



public class WSDLGenerator {

	private String tns;
	private String bpelProcessName;


	public WSDLGenerator(String tns, String bpelProcessName) {
		this.tns = tns;
		this.bpelProcessName = bpelProcessName;
	}


	public File generate(String bpelUrl, String fileName) throws IOException {
		File f = new File(bpelUrl + "/" + fileName);
		FileWriter writer = null;
		try {
			writer = new FileWriter(f);
			writer.write("<?xml version=\"1.0\"?>\r\n" + 
					"<definitions name=\"" + this.bpelProcessName + "\" targetNamespace=\"" + this.tns + "\"\r\n" + 
					"	xmlns:tns=\"" + this.tns + "\" xmlns:plnk=\"http://docs.oasis-open.org/wsbpel/2.0/plnktype\"\r\n" + 
					"	xmlns=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\">\r\n" + 
					"\r\n" + 
					"	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \r\n" + 
					"		TYPE DEFINITION - List of types participating in this BPEL process The BPEL \r\n" + 
					"		Designer will generate default request and response types but you can define \r\n" + 
					"		or import any XML Schema type and use them as part of the message types. \r\n" + 
					"		~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\r\n" + 
					"	<types>\r\n" + 
					"		<schema attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\"\r\n" + 
					"			targetNamespace=\"" + this.tns + "\" xmlns=\"http://www.w3.org/2001/XMLSchema\">\r\n" + 
					"\r\n" + 
					"			<element name=\"" + this.bpelProcessName + "Request\">\r\n" + 
					"				<complexType>\r\n" + 
					"					<sequence>\r\n" + 
					"						<element name=\"input\" type=\"string\" />\r\n" + 
					"					</sequence>\r\n" + 
					"				</complexType>\r\n" + 
					"			</element>\r\n" + 
					"\r\n" + 
					"			<element name=\"" + this.bpelProcessName + "Response\">\r\n" + 
					"				<complexType>\r\n" + 
					"					<sequence>\r\n" + 
					"						<element name=\"result\" type=\"string\" />\r\n" + 
					"					</sequence>\r\n" + 
					"				</complexType>\r\n" + 
					"			</element>\r\n" + 
					"		</schema>\r\n" + 
					"	</types>\r\n" + 
					"\r\n" + 
					"\r\n" + 
					"	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \r\n" + 
					"		MESSAGE TYPE DEFINITION - Definition of the message types used as part of \r\n" + 
					"		the port type defintions ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\r\n" + 
					"	<message name=\"" + this.bpelProcessName + "RequestMessage\">\r\n" + 
					"		<part name=\"payload\" element=\"tns:" + this.bpelProcessName + "Request\" />\r\n" + 
					"	</message>\r\n" + 
					"	<message name=\"" + this.bpelProcessName + "ResponseMessage\">\r\n" + 
					"		<part name=\"payload\" element=\"tns:" + this.bpelProcessName + "Response\" />\r\n" + 
					"	</message>\r\n" + 
					"\r\n" + 
					"	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \r\n" + 
					"		PORT TYPE DEFINITION - A port type groups a set of operations into a logical \r\n" + 
					"		service unit. ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\r\n" + 
					"\r\n" + 
					"	<!-- portType implemented by the HelloWorld BPEL process -->\r\n" + 
					"	<portType name=\"" + this.bpelProcessName + "\">\r\n" + 
					"		<operation name=\"process\">\r\n" + 
					"			<input message=\"tns:" + this.bpelProcessName + "RequestMessage\" />\r\n" + 
					"			<output message=\"tns:" + this.bpelProcessName + "ResponseMessage\" />\r\n" + 
					"		</operation>\r\n" + 
					"	</portType>\r\n" + 
					"	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \r\n" + 
					"		PARTNER LINK TYPE DEFINITION ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\r\n" + 
					"	<plnk:partnerLinkType name=\"" + this.bpelProcessName + "\">\r\n" + 
					"		<plnk:role name=\"" + this.bpelProcessName + "Provider\" portType=\"tns:" + this.bpelProcessName + "\" />\r\n" + 
					"	</plnk:partnerLinkType>\r\n" + 
					"\r\n" + 
					"\r\n" + 
					"	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \r\n" + 
					"		BINDING DEFINITION - Defines the message format and protocol details for \r\n" + 
					"		a web service. ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\r\n" + 
					"	<binding name=\"" + this.bpelProcessName + "Binding\" type=\"tns:" + this.bpelProcessName + "\">\r\n" + 
					"		<soap:binding style=\"document\"\r\n" + 
					"			transport=\"http://schemas.xmlsoap.org/soap/http\" />\r\n" + 
					"		<operation name=\"process\">\r\n" + 
					"			<soap:operation soapAction=\"" + this.tns + "/process\" />\r\n" + 
					"			<input>\r\n" + 
					"				<soap:body use=\"literal\" />\r\n" + 
					"			</input>\r\n" + 
					"			<output>\r\n" + 
					"				<soap:body use=\"literal\" />\r\n" + 
					"			</output>\r\n" + 
					"		</operation>\r\n" + 
					"	</binding>\r\n" + 
					"\r\n" + 
					"	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \r\n" + 
					"		SERVICE DEFINITION - A service groups a set of ports into a service unit. \r\n" + 
					"		~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\r\n" + 
					"	<service name=\"" + this.bpelProcessName + "\">\r\n" + 
					"		<port name=\"" + this.bpelProcessName + "Port\" binding=\"tns:" + this.bpelProcessName + "Binding\">\r\n" + 
					"			<soap:address location=\"http://localhost:8080/" + this.bpelProcessName + "\" />\r\n" + 
					"		</port>\r\n" + 
					"	</service>\r\n" + 
					"</definitions>");
		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}
}
