/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.sdk.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.xml.namespace.QName;
import org.petalslink.easiestdemo.sdk.SDKException;
import org.petalslink.easiestdemo.sdk.SDKService;
import org.petalslink.easiestdemo.sdk.gui.BPELFilter;
import org.petalslink.easiestdemo.sdk.gui.JTextAreaOutputStream;
import org.petalslink.easiestdemo.sdk.util.JPanelImageBg;

public class SDKGui
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final URL BACKGROUND_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/fond_ecran_sombre_800x600.png");
    private static final URL ICON_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/easylink-ico.png");
    private static final URL ICON_ARROW_BLUE_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/next-bleu-arrow.png");
    private static final URL ICON_CREATE_PROJECT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/createProject.png");
    private static final URL ICON_COMPILE_PROJECT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/compileProject.png");
    private static final URL ICON_RUN_PROJECT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/runProject.png");
    private static final String DEFAULT_OUT_DIRECTORY = System.getProperty("user.home") + File.separator + "EasiestDemoProjects";
    private SDKService service = new SDKService();
    private QName bpelProcess = null;
    private ButtonGroup buttonGroupCreateMavenProject;
    private JButton jButtonBrowseOutputDirectory;
    private JButton jButtonBrowseProject;
    private JButton jButtonCompileProject;
    private JButton jButtonCreateProject;
    private JButton jButtonRunProject;
    private JLabel jLabelBpelNameOrUrl;
    private JLabel jLabelOutputDirectory;
    private JLabel jLabelStep1ToStep2;
    private JLabel jLabelStep2ToStep3;
    private JPanel jPanelActions;
    private JPanel jPanelMain;
    private JPanel jPanelOutputConsole;
    private JRadioButton jRadioButtonMavenProjectFromBpel;
    private JRadioButton jRadioButtonNewMavenProject;
    private JScrollPane jScrollPaneOutputTextArea;
    private JTextArea jTextAreaOutputTextArea;
    private JTextField jTextFieldOutputDirectory;
    private JTextField jTextFieldProject;

    public SDKGui() {
        this.setTitle("EasiestDemo SDK");
        this.setLocation();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ICON_IMAGE));
        ImageIcon imgIcon = new ImageIcon(BACKGROUND_IMAGE);
        Image backgroundImg = imgIcon.getImage().getScaledInstance(1024, 1024, 4);
        this.setContentPane(new JPanelImageBg(backgroundImg));
        this.initComponents();
        JTextAreaOutputStream outStream = new JTextAreaOutputStream(this.jTextAreaOutputTextArea);
        JTextAreaOutputStream errStream = new JTextAreaOutputStream(this.jTextAreaOutputTextArea);
        System.setOut(new PrintStream(outStream));
        System.setErr(new PrintStream(errStream));
        this.setBackground(Color.black);
        this.jPanelMain.setOpaque(false);
        this.jPanelActions.setOpaque(false);
        this.jPanelOutputConsole.setOpaque(false);
        this.jRadioButtonMavenProjectFromBpel.setOpaque(false);
        this.jRadioButtonNewMavenProject.setOpaque(false);
        this.jButtonCreateProject.setIcon(this.createImageIcon(this.jButtonCreateProject, ICON_CREATE_PROJECT_IMAGE));
        this.jButtonCompileProject.setIcon(this.createImageIcon(this.jButtonCompileProject, ICON_COMPILE_PROJECT_IMAGE));
        this.jButtonRunProject.setIcon(this.createImageIcon(this.jButtonRunProject, ICON_RUN_PROJECT_IMAGE));
        this.jLabelStep1ToStep2.setIcon(new ImageIcon(ICON_ARROW_BLUE_IMAGE));
        this.jLabelStep2ToStep3.setIcon(new ImageIcon(ICON_ARROW_BLUE_IMAGE));
        this.jButtonCreateProject.setText("");
        this.jButtonCompileProject.setText("");
        this.jButtonRunProject.setText("");
        this.jLabelStep1ToStep2.setText("");
        this.jLabelStep2ToStep3.setText("");
        this.jRadioButtonNewMavenProjectActionPerformed(null);
        this.disabledAll();
        this.jTextFieldOutputDirectory.setText(DEFAULT_OUT_DIRECTORY.toString());
        this.jTextFieldProject.setText("{http://wwww.petalslink.com}HelloWorldProcess");
        this.jTextFieldProjectKeyPressed(null);
    }

    private ImageIcon createImageIcon(JButton button, URL url) {
        ImageIcon icon = new ImageIcon(url);
        Image img = icon.getImage();
        Image newImg = img.getScaledInstance(button.getWidth(), button.getHeight(), 4);
        icon = new ImageIcon(newImg);
        return icon;
    }

    private void disabledAll() {
        this.jButtonCreateProject.setEnabled(false);
        this.jButtonCompileProject.setEnabled(false);
        this.jButtonRunProject.setEnabled(false);
        this.jLabelStep1ToStep2.setEnabled(false);
        this.jLabelStep2ToStep3.setEnabled(false);
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 4, (int)heightScreen / 4);
    }

    private void initComponents() {
        this.buttonGroupCreateMavenProject = new ButtonGroup();
        this.jPanelMain = new JPanel();
        this.jRadioButtonNewMavenProject = new JRadioButton();
        this.jRadioButtonMavenProjectFromBpel = new JRadioButton();
        this.jTextFieldProject = new JTextField();
        this.jButtonBrowseProject = new JButton();
        this.jLabelOutputDirectory = new JLabel();
        this.jTextFieldOutputDirectory = new JTextField();
        this.jButtonBrowseOutputDirectory = new JButton();
        this.jPanelOutputConsole = new JPanel();
        this.jScrollPaneOutputTextArea = new JScrollPane();
        this.jTextAreaOutputTextArea = new JTextArea();
        this.jPanelActions = new JPanel();
        this.jButtonCreateProject = new JButton();
        this.jButtonCompileProject = new JButton();
        this.jButtonRunProject = new JButton();
        this.jLabelStep1ToStep2 = new JLabel();
        this.jLabelStep2ToStep3 = new JLabel();
        this.jLabelBpelNameOrUrl = new JLabel();
        this.setDefaultCloseOperation(3);
        this.buttonGroupCreateMavenProject.add(this.jRadioButtonNewMavenProject);
        this.jRadioButtonNewMavenProject.setText("Create New Bpel Maven Project");
        this.jRadioButtonNewMavenProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDKGui.this.jRadioButtonNewMavenProjectActionPerformed(evt);
            }
        });
        this.buttonGroupCreateMavenProject.add(this.jRadioButtonMavenProjectFromBpel);
        this.jRadioButtonMavenProjectFromBpel.setText("Create Bpel Maven Project from existing Bpel ");
        this.jRadioButtonMavenProjectFromBpel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDKGui.this.jRadioButtonMavenProjectFromBpelActionPerformed(evt);
            }
        });
        this.jTextFieldProject.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SDKGui.this.jTextFieldProjectKeyPressed(evt);
            }
        });
        this.jButtonBrowseProject.setText("Parcourir...");
        this.jButtonBrowseProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDKGui.this.jButtonBrowseProjectActionPerformed(evt);
            }
        });
        this.jLabelOutputDirectory.setText("Output Directory:");
        this.jTextFieldOutputDirectory.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SDKGui.this.jTextFieldOutputDirectoryKeyPressed(evt);
            }
        });
        this.jButtonBrowseOutputDirectory.setText("Parcourir...");
        this.jButtonBrowseOutputDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDKGui.this.jButtonBrowseOutputDirectoryActionPerformed(evt);
            }
        });
        this.jPanelOutputConsole.setBorder(BorderFactory.createTitledBorder("Output Console"));
        this.jTextAreaOutputTextArea.setColumns(20);
        this.jTextAreaOutputTextArea.setRows(5);
        this.jScrollPaneOutputTextArea.setViewportView(this.jTextAreaOutputTextArea);
        GroupLayout jPanelOutputConsoleLayout = new GroupLayout(this.jPanelOutputConsole);
        this.jPanelOutputConsole.setLayout(jPanelOutputConsoleLayout);
        jPanelOutputConsoleLayout.setHorizontalGroup(jPanelOutputConsoleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOutputConsoleLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneOutputTextArea, -1, 707, Short.MAX_VALUE).addContainerGap()));
        jPanelOutputConsoleLayout.setVerticalGroup(jPanelOutputConsoleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOutputConsoleLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneOutputTextArea, -1, 248, Short.MAX_VALUE).addContainerGap()));
        this.jPanelActions.setBorder(BorderFactory.createTitledBorder("Actions"));
        this.jButtonCreateProject.setText("Create Project");
        this.jButtonCreateProject.setMaximumSize(new Dimension(107, 23));
        this.jButtonCreateProject.setMinimumSize(new Dimension(107, 23));
        this.jButtonCreateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDKGui.this.jButtonCreateProjectActionPerformed(evt);
            }
        });
        this.jButtonCompileProject.setText("Compile Project");
        this.jButtonCompileProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDKGui.this.jButtonCompileProjectActionPerformed(evt);
            }
        });
        this.jButtonRunProject.setText("Run Project");
        this.jButtonRunProject.setMaximumSize(new Dimension(107, 23));
        this.jButtonRunProject.setMinimumSize(new Dimension(107, 23));
        this.jButtonRunProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDKGui.this.jButtonRunProjectActionPerformed(evt);
            }
        });
        this.jLabelStep1ToStep2.setText(".... -> ....");
        this.jLabelStep2ToStep3.setText(".... -> ....");
        GroupLayout jPanelActionsLayout = new GroupLayout(this.jPanelActions);
        this.jPanelActions.setLayout(jPanelActionsLayout);
        jPanelActionsLayout.setHorizontalGroup(jPanelActionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionsLayout.createSequentialGroup().addGap(142, 142, 142).addComponent(this.jButtonCreateProject, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelStep1ToStep2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCompileProject).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelStep2ToStep3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRunProject, -2, -1, -2).addContainerGap(158, Short.MAX_VALUE)));
        jPanelActionsLayout.setVerticalGroup(jPanelActionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelActionsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanelActionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonRunProject, -2, 90, -2).addComponent(this.jButtonCompileProject, -2, 90, -2).addComponent(this.jButtonCreateProject, -2, 90, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanelActionsLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, -2).addComponent(this.jLabelStep1ToStep2).addGap(39, 39, 39)).addGroup(GroupLayout.Alignment.TRAILING, jPanelActionsLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, -2).addComponent(this.jLabelStep2ToStep3).addGap(37, 37, 37))).addContainerGap()));
        this.jLabelBpelNameOrUrl.setText("Bpel QName [{tns}name] :");
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMavenProjectFromBpel, -1, 893, Short.MAX_VALUE).addComponent(this.jRadioButtonNewMavenProject, -1, 893, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelBpelNameOrUrl).addComponent(this.jLabelOutputDirectory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldProject).addComponent(this.jTextFieldOutputDirectory, -2, 357, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonBrowseProject, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonBrowseOutputDirectory, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 312, Short.MAX_VALUE)).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanelOutputConsole, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelActions, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jRadioButtonNewMavenProject).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonMavenProjectFromBpel).addGap(18, 18, 18).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelBpelNameOrUrl).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldProject, -2, -1, -2).addComponent(this.jButtonBrowseProject)).addGap(18, 18, 18).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldOutputDirectory, -2, -1, -2).addComponent(this.jButtonBrowseOutputDirectory).addComponent(this.jLabelOutputDirectory)))).addGap(26, 26, 26).addComponent(this.jPanelActions, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanelOutputConsole, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanelMain, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jRadioButtonNewMavenProjectActionPerformed(ActionEvent evt) {
        this.jRadioButtonNewMavenProject.setSelected(true);
        this.jLabelBpelNameOrUrl.setText("Bpel QName : ");
        this.jButtonBrowseProject.setVisible(false);
        this.jTextFieldProject.setText("");
        this.jTextFieldProjectKeyPressed(null);
    }

    private void jRadioButtonMavenProjectFromBpelActionPerformed(ActionEvent evt) {
        this.jRadioButtonMavenProjectFromBpel.setSelected(true);
        this.jLabelBpelNameOrUrl.setText("Bpel URL : ");
        this.jButtonBrowseProject.setVisible(true);
        this.jTextFieldProject.setText("");
        this.jTextFieldProjectKeyPressed(null);
    }

    private void jButtonBrowseProjectActionPerformed(ActionEvent evt) {
        JFileChooser c = new JFileChooser();
        c.addChoosableFileFilter(new BPELFilter());
        c.setAcceptAllFileFilterUsed(false);
        int rVal = c.showOpenDialog(this);
        if (rVal == 0) {
            this.jTextFieldProject.setText(c.getSelectedFile().getAbsolutePath());
            this.jTextFieldProjectKeyPressed(null);
        }
        if (rVal == 1) {
            this.jTextFieldProject.setText("");
        }
    }

    private void jButtonBrowseOutputDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser c = new JFileChooser();
        c.setFileSelectionMode(1);
        int rVal = c.showOpenDialog(this);
        if (rVal == 0) {
            this.jTextFieldOutputDirectory.setText(c.getSelectedFile().getAbsolutePath());
            this.jTextFieldOutputDirectoryKeyPressed(null);
        }
        if (rVal == 1) {
            this.jTextFieldOutputDirectory.setText("");
        }
    }

    private void jButtonCreateProjectActionPerformed(ActionEvent evt) {
        try {
            boolean generateFile = false;
            generateFile = this.jRadioButtonNewMavenProject.isSelected();
            this.paint(this.getGraphics());
            if (generateFile) {
                this.bpelProcess = QName.valueOf(this.jTextFieldProject.getText());
                this.bpelProcess = this.service.createNewProject(this.bpelProcess.getNamespaceURI(), this.bpelProcess.getLocalPart(), new File(this.jTextFieldOutputDirectory.getText()), true);
            } else {
                this.bpelProcess = this.service.createProjectFromBpel(new File(this.jTextFieldProject.getText()).toURI().toURL(), new File(this.jTextFieldOutputDirectory.getText()));
            }
            if (this.bpelProcess != null) {
                int res = this.service.importProjectIntoEclipse(new File(this.jTextFieldOutputDirectory.getText() + "/" + this.bpelProcess.getLocalPart().toLowerCase()), null);
                if (res == 0) {
                    String msg = "Bpel project create at: " + this.jTextFieldOutputDirectory.getText() + "/" + this.bpelProcess.getLocalPart().toLowerCase() + "\nYou can now open your project in eclipse IDE: Click on File->Import->General->Import existing project in your workspace";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, "Creation Succesfull", 1);
                    this.jLabelStep1ToStep2.setEnabled(true);
                    this.jButtonCompileProject.setEnabled(true);
                } else {
                    String msg = "Impossible to import project, sorry!!!";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, "Creation Interrupted", 0);
                }
            } else {
                String msg = "Impossible to create project, sorry!!!";
                System.out.println(msg);
                JOptionPane.showMessageDialog(this, msg, "Creation Interrupted", 0);
            }
        }
        catch (SDKException e) {
            e.printStackTrace(System.out);
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.out);
        }
    }

    private void jButtonCompileProjectActionPerformed(ActionEvent evt) {
        try {
            int res = this.service.compileProject(new File(this.jTextFieldOutputDirectory.getText() + "/" + this.bpelProcess.getLocalPart().toLowerCase()), null);
            if (res == 0) {
                String msg = "Bpel compiled. You can now run it!!!";
                System.out.println(msg);
                JOptionPane.showMessageDialog(this, msg, "Creation Succesfull", 1);
                this.jLabelStep2ToStep3.setEnabled(true);
                this.jButtonRunProject.setEnabled(true);
            } else {
                String msg = "Impossible to compile project, sorry!!!";
                System.out.println(msg);
                JOptionPane.showMessageDialog(this, msg, "Compilation Interrupted", 0);
            }
        }
        catch (SDKException e) {
            System.out.println(e.getMessage());
        }
    }

    private void jButtonRunProjectActionPerformed(ActionEvent evt) {
        try {
            this.service.runProject(new File(this.jTextFieldOutputDirectory.getText() + "/" + this.bpelProcess.getLocalPart().toLowerCase()), null);
        }
        catch (SDKException e) {
            System.out.println(e.getMessage());
        }
    }

    private void jTextFieldOutputDirectoryKeyPressed(KeyEvent evt) {
        if (this.jTextFieldProject.getText() != null && this.jTextFieldProject.getText().trim().length() > 0 && this.jTextFieldOutputDirectory.getText() != null && this.jTextFieldOutputDirectory.getText().trim().length() > 0) {
            this.jButtonCreateProject.setEnabled(true);
        } else {
            this.disabledAll();
        }
    }

    private void jTextFieldProjectKeyPressed(KeyEvent evt) {
        if (this.jTextFieldProject.getText() != null && this.jTextFieldProject.getText().trim().length() > 0 && this.jTextFieldOutputDirectory.getText() != null && this.jTextFieldOutputDirectory.getText().trim().length() > 0) {
            this.jButtonCreateProject.setEnabled(true);
        } else {
            this.disabledAll();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SDKGui().setVisible(true);
            }
        });
    }
}

