package com.ebmwebsourcing.easybox.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class XQueryValidationProfile {

    private final String name;
    private final Set<XQueryValidationRule> rules;
    
    public XQueryValidationProfile(String name) {
        assert name != null;
        this.name = name;
        this.rules = new TreeSet<XQueryValidationRule>();
    }

    public String getName() {
        return name;
    }

    public void addRule(XQueryValidationRule rule) {
        rules.add(rule);
    }
    
    public Collection<XQueryValidationRule> getRules() {
        return Collections.unmodifiableSet(rules);
    }
    
    
}
