package com.ebmwebsourcing.easybox.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class XQueryValidationReport {

    private final List<XQueryValidationRuleReport> ruleReports;
    
    public XQueryValidationReport() {
        this.ruleReports = new ArrayList<XQueryValidationRuleReport>();
    }

    public void addRuleReport(XQueryValidationRuleReport ruleReport) {
        ruleReports.add(ruleReport);
    }
    
    public Collection<XQueryValidationRuleReport> getRuleReports() {
        return Collections.unmodifiableCollection(ruleReports);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((ruleReports == null) ? 0 : ruleReports.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        XQueryValidationReport other = (XQueryValidationReport) obj;
        if (ruleReports == null) {
            if (other.ruleReports != null)
                return false;
        } else if (!ruleReports.equals(other.ruleReports))
            return false;
        return true;
    }
    
    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (XQueryValidationRuleReport ruleReport : ruleReports) {
            sb.append(String.valueOf(ruleReport)).append("\n");
        }
        return sb.toString();
    }
    
}
