package com.ebmwebsourcing.easybox.api;

import org.xml.sax.ErrorHandler;

/**
 * Class aimed at validating specific {@link XmlObject} class.
 * 
 * @author mjambert
 */
public interface XmlObjectValidator {

    /**
     * Fail fast validate a given {@link XmlObject}, throwing an exception as
     * soon as a first error is encountered.
     * 
     * @param xmlObject
     *            {@link XmlObject} instance to be validated.
     * @throws XmlObjectValidationException
     *             Exception thrown when first validation error is encountered, or if any
     *             other problem is encountered.
     */
    void failFastValidate(XmlObject xmlObject) throws XmlObjectValidationException;

    /**
     * Validate a given {@link XmlObject}, and forwards SAX errors to an
     * {@link ErrorHandler}.
     * 
     * @param xmlObject
     *            {@link XmlObject} instance to be validated.
     * @param errorHandler
     *            {@link ErrorHandler} receiving validation errors.
     */
    void validate(XmlObject xmlObject, ErrorHandler errorHandler);

}
