package com.ebmwebsourcing.easybox.api.analysis;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public final class ClassMetadata {

    private Map<Class<?>, Map<String, Object>> classesMetadata = new IdentityHashMap<Class<?>, Map<String, Object>>();

    public ClassMetadata() {
    }

    private final Map<String, Object> doGet(Class<?> clazz) {
        if (!classesMetadata.containsKey(clazz)) {
            classesMetadata.put(clazz, new HashMap<String, Object>());
        }
        return classesMetadata.get(clazz);
    }

    public void clear() {
    	classesMetadata.clear();
    }
    
    
    public boolean has(Class<?> clazz, String key) {
        return doGet(clazz).containsKey(key);
    }
    
    
    @SuppressWarnings("unchecked")
    public <X> X get(Class<?> clazz, String key) {
        Map<String, Object> classMetadata = doGet(clazz);
        if (!classMetadata.containsKey(key)) {
            throw new UncheckedException(String.format(
                    "No such key '%s' in class '%s' metadata.", key,
                    clazz.getName()));
        }
        return (X) classMetadata.get(key);
    }
    
    
    public void put(Class<?> clazz, String key, Object classMetadata) {
        doGet(clazz).put(key, classMetadata);
    }

}
