package com.ebmwebsourcing.easybox.api;

public final class XQueryValidationRule implements Comparable<XQueryValidationRule> {

    private final String name;
    private final String description;
    private final String xquery;
    
    public XQueryValidationRule(String name, String description, String xquery) {
        assert name != null;
        assert description != null;
        assert xquery != null;
        this.name = name;
        this.description = description;
        this.xquery = xquery;
    }

    public String getName() {
        return name;
    }
    
    public String getDescription() {
        return description;
    }

    public String getXQuery() {
        return xquery;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((description == null) ? 0 : description.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + ((xquery == null) ? 0 : xquery.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        XQueryValidationRule other = (XQueryValidationRule) obj;
        if (description == null) {
            if (other.description != null)
                return false;
        } else if (!description.equals(other.description))
            return false;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (xquery == null) {
            if (other.xquery != null)
                return false;
        } else if (!xquery.equals(other.xquery))
            return false;
        return true;
    }
    
    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Rule '").append(getName()).append("':\n");
        sb.append(getDescription()).append("\n");
        sb.append(getXQuery());
        return sb.toString();
    }

    @Override
    public int compareTo(XQueryValidationRule rule) {
        assert rule != null;
        return getName().compareTo(rule.getName());
    }
    
    
}
