package com.ebmwebsourcing.easybox.api;

import java.util.Iterator;
import java.util.ServiceLoader;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;


public final class XmlContextFactory {

    private final Iterable<XmlContext> xmlContexts;
    
    public XmlContextFactory() {
        this(ServiceLoader.load(XmlContext.class));
    }
    
    XmlContextFactory(Iterable<XmlContext> xmlContexts) {
        this.xmlContexts = xmlContexts;
    }
    
    public XmlContext newContext() {
        return newContext(new String[0]);
    }
    
    
    public XmlContext newContext(String[] bindingNames) {
        Iterator<XmlContext> it = xmlContexts.iterator();
        XmlContext xmlContextImpl = null;
        while (it.hasNext()) {
            xmlContextImpl = it.next();
            break;
        }
        if (xmlContextImpl == null) {
            throw new UncheckedException("No XmlContext implementation found in classpath.");
        }
        xmlContextImpl.addXmlObjectBindings(bindingNames);
        return xmlContextImpl;
    }
    
    

}
