package com.ebmwebsourcing.easybox.api.analysis;

import com.ebmwebsourcing.easybox.api.XmlObjectNode;

public class MultipleInterfacesImplementedException extends AnalyzerException {

    private static final long serialVersionUID = -3863364688263790645L;
    
    private static final String MESSAGE = 
        "Implementation class '%s' MUST implement one and only one interface extending XmlObjectNode.";
    
    public MultipleInterfacesImplementedException(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) {
        super(String.format(MESSAGE, xmlObjectNodeImplClass.getSimpleName()));
    }

    
}
