/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api.with;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithOtherAttributesTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_OTHER_ATTRIBUTES = "expectedOtherAttributes";

    public WithOtherAttributesTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetOtherAttributes() {
        WithOtherAttributes openAttrs = (WithOtherAttributes)this.newXmlObjectUnderTest();
        Map expectedOtherAttributes = (Map)this.getTestData(EXPECTED_OTHER_ATTRIBUTES);
        Assert.assertEquals((Object)expectedOtherAttributes, (Object)openAttrs.getOtherAttributes());
    }

    @Test
    public void testHasOtherAttribute() {
        WithOtherAttributes openAttrs = (WithOtherAttributes)this.newXmlObjectUnderTest();
        Map expectedOtherAttributes = (Map)this.getTestData(EXPECTED_OTHER_ATTRIBUTES);
        for (QName qname : expectedOtherAttributes.keySet()) {
            Assert.assertTrue((boolean)openAttrs.hasOtherAttribute(qname));
        }
    }

    @Test
    public void testGetOtherAttribute() {
        WithOtherAttributes openAttrs = (WithOtherAttributes)this.newXmlObjectUnderTest();
        Map expectedOtherAttributes = (Map)this.getTestData(EXPECTED_OTHER_ATTRIBUTES);
        for (QName key : expectedOtherAttributes.keySet()) {
            Assert.assertEquals(expectedOtherAttributes.get(key), (Object)openAttrs.getOtherAttribute(key));
        }
    }

    @Test
    public void testAddOtherAttribute() {
        WithOtherAttributes openAttrs = (WithOtherAttributes)this.newXmlObjectUnderTest();
        QName newOtherAttributeQName = new QName("http://new/other/attribute/namespace", "att");
        String newOtherAttributeValue = "newOtherAttributeValue";
        HashMap<QName, String> expectedOtherAttributes = (HashMap<QName, String>)this.getTestData(EXPECTED_OTHER_ATTRIBUTES);
        expectedOtherAttributes = new HashMap<QName, String>(expectedOtherAttributes);
        openAttrs.addOtherAttribute(newOtherAttributeQName, "newOtherAttributeValue");
        expectedOtherAttributes.put(newOtherAttributeQName, "newOtherAttributeValue");
        Assert.assertEquals(expectedOtherAttributes, (Object)openAttrs.getOtherAttributes());
    }

    @Test
    public void testRemoveOtherAttribute() {
        WithOtherAttributes openAttrs = (WithOtherAttributes)this.newXmlObjectUnderTest();
        for (QName key : openAttrs.getOtherAttributes().keySet()) {
            openAttrs.removeOtherAttribute(key);
            Assert.assertFalse((boolean)openAttrs.hasOtherAttribute(key));
        }
    }

    @Test
    public void testClearOtherAttributes() {
        WithOtherAttributes openAttrs = (WithOtherAttributes)this.newXmlObjectUnderTest();
        openAttrs.clearOtherAttributes();
        Assert.assertEquals((long)0L, (long)openAttrs.getOtherAttributes().size());
    }
}

