/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.api;


public interface XmlObjectFactory {

    /**
     * Wrap any object into an implementation of {@link XmlObjectNode}.
     * Implementation class is guessed from known meta-information.
     * 
     * @param obj
     *            Internal model object to be wrapped.
     * @return Newly created concrete {@link XmlObjectNode}.
     */
    XmlObjectNode wrap(Object obj);

    /**
     * Wrap any object into a specific implementation of {@link XmlObjectNode}.
     * 
     * @param <X>
     *            Type of desired {@link XmlObjectNode} interface.
     * @param obj
     *            Model object to be wrapped.
     * @param xmlObjectClassOrInterface
     *            Desired {@link XmlObjectNode} interface class. For convenience,
     *            one can also provide directly the desired implementation class
     *            to prevent unnecessary lookup in metadata.
     * @return Newly created concrete {@link XmlObjectNode}.
     */
    <X extends XmlObjectNode> X wrap(Object obj, Class<X> xmlObjectClassOrInterface);

    /**
     * Create a new {@link XmlObjectNode} given its interface class. Implementation
     * class is guessed from known meta-information.
     * 
     * @param <X>
     *            Class of {@link XmlObjectNode} to be created.
     * @param xmlObjectClassOrInterface
     *            Class of {@link XmlObjectNode} to be created.
     * @return Newly created {@link XmlObjectNode}.
     */
    <X extends XmlObjectNode> X create(Class<X> xmlObjectClassOrInterface);

}
