/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.api;

public interface XmlObjectSchemaBinding extends XmlObjectBinding {
    
    /**
     * Get package of {@link ModelObject} objects that this delegate knows how
     * to wrap.
     * 
     * @return {@link ModelObject} objects package.
     */
    Package getModelObjectPackage();
    
    /**
     * Get the name of the originating schema directory resource. The
     * originating schema is the schema which was used to generate corresponding
     * {@link ModelObject} objects.
     * 
     * @return /-separated path name that identifies the schema directory
     *         resource path.
     */
    String getOriginatingSchemaDir();

    /**
     * Get the name of the originating schema file. The originating schema is
     * the schema which was used to generate corresponding {@link ModelObject}
     * objects.
     * 
     * @return Simple schema file name, without path.
     */
    String getOriginatingSchemaName();

    /**
     * Get the namespace URI of the originating schema file. The originating
     * schema is the schema which was used to generate corresponding
     * {@link ModelObject} objects.
     * 
     * @return Schema namespace URI.
     */
    String getOriginatingSchemaNamespaceURI();

    /**
     * Get preferred prefix for the originating schema namespace URI. This
     * prefix will be preferably used for marshalling. The originating schema is
     * the schema which was used to generate corresponding {@link ModelObject}
     * objects.
     * 
     * @return Preferred prefix for the originating schema namespace URI.
     */
    String getOriginatingSchemaPreferredNamespacePrefix();

}
