package com.ebmwebsourcing.easybox.impl;

import static com.ebmwebsourcing.easybox.api.ClassMetadataConstants.*;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectSchemaBinding;
import com.ebmwebsourcing.easybox.api.analysis.ClassMetadata;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public abstract class AbstractXmlObjectSchemaBindingImpl implements
        XmlObjectSchemaBinding {

    private final JaxbSchemaBinding jaxbSchemaBinding;

    protected AbstractXmlObjectSchemaBindingImpl() {
        this.jaxbSchemaBinding = JaxbSchemaBinding.getJaxbSchemaBindings().get(
                getOriginatingSchemaNamespaceURI());
    }

    public abstract Package getModelObjectPackage();

    @Override
    public final boolean canWrap(Object obj) {
        if (obj instanceof JAXBElement<?>) {
            return ((JAXBElement<?>) obj).getValue().getClass().getPackage()
                    .equals(getModelObjectPackage());
        } else if (obj instanceof ModelObject) {
            return obj.getClass().getPackage().equals(getModelObjectPackage());
        }
        return false;
    }

    protected abstract XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObject) throws InstantiationException,
            IllegalAccessException, InvocationTargetException;

    @Override
    public final <X extends XmlObjectNode> X wrap(XmlContext xmlContext,
            Class<X> xmlObjectImplClass, Object obj) {
        assert AbstractJaxbXmlObjectImpl.class
                .isAssignableFrom(xmlObjectImplClass);
        ModelObject modelObject = null;
        if (obj != null) {
            if (obj instanceof ModelObject) {
                modelObject = (ModelObject) obj;
            } else if (obj instanceof JAXBElement<?>) {
                modelObject = (ModelObject) ((JAXBElement<?>) obj).getValue();
            } else {
                throw new UncheckedException(String.format(
                        "Do not know how to wrap object of class '%s'.", obj
                                .getClass().getSimpleName()));
            }
        }
        try {
            AbstractJaxbModelObject ajo = (AbstractJaxbModelObject) modelObject;
            Constructor<? extends XmlObject> constructor = xmlContext
                    .getClassMetadata().get(xmlObjectImplClass,
                            IMPLEMENTATION_CLASS_CONSTRUCTOR);
            constructor.setAccessible(true);
            X xmlObjectImpl = xmlObjectImplClass.cast(doWrap(xmlContext,
                    constructor, ajo));
            return xmlObjectImpl;
        } catch (Exception e) {
            throw new UncheckedException("Problem while wrapping class", e);
        }
    }

    private Class<? extends XmlObjectNode>[] findXmlObjectImplClassesByModelObjectClass(
            XmlContext xmlContext, Class<? extends ModelObject> modelObjectClass) {
        if (!xmlContext.getClassMetadata().has(modelObjectClass,
                IMPLEMENTATION_CLASSES_METADATA)) {
            xmlContext.getClassMetadata().put(
                    modelObjectClass,
                    IMPLEMENTATION_CLASSES_METADATA,
                    doFindXmlObjectImplClassesByModelObjectClass(xmlContext,
                            modelObjectClass));
        }
        return xmlContext.getClassMetadata().get(modelObjectClass,
                IMPLEMENTATION_CLASSES_METADATA);
    }

    @SuppressWarnings("unchecked")
    private Class<? extends XmlObjectNode>[] doFindXmlObjectImplClassesByModelObjectClass(
            XmlContext xmlContext, Class<? extends ModelObject> modelObjectClass) {
        List<Class<? extends XmlObjectNode>> result = new ArrayList<Class<? extends XmlObjectNode>>();
        for (Class<? extends XmlObjectNode> implClass : getFactorableClasses()) {
            Class<? extends ModelObject> moc = xmlContext.getClassMetadata()
                    .get(implClass, IMPLEMENTATION_CLASS_MODELOBJECT_CLASS);
            if (moc.isAssignableFrom(modelObjectClass)) {
                result.add(implClass);
            }
        }
        return result.toArray((Class[]) Array.newInstance(Class.class,
                result.size()));
    }

    @Override
    public final XmlObjectNode wrap(XmlContext xmlContext, Object obj) {
        assert obj != null;

        assert (obj instanceof AbstractJaxbModelObject)
                || (obj instanceof JAXBElement<?>) : String.format(
                "Cannot wrap instances of '%s'", obj.getClass());

        QName qname = null;
        AbstractJaxbModelObject ajo = null;
        Class<? extends XmlObjectNode> guessedImplClass = null;
        if (obj instanceof JAXBElement<?>) {
            JAXBElement<?> jaxbElement = (JAXBElement<?>) obj;
            qname = jaxbElement.getName();
            ajo = (AbstractJaxbModelObject) jaxbElement.getValue();
        } else if (obj instanceof AbstractJaxbModelObject) {
            ajo = (AbstractJaxbModelObject) obj;
            qname = ajo.getQName();
        }

        Class<? extends ModelObject> modelObjectClass = ajo.getClass();

        Class<? extends XmlObjectNode>[] xmlObjectImplClasses = findXmlObjectImplClassesByModelObjectClass(
                xmlContext, modelObjectClass);
        ClassMetadata cmd = xmlContext.getClassMetadata();

        if (xmlObjectImplClasses.length == 0) {
            throw new UncheckedException(String.format(
                    "Do not know how to wrap object of class '%s'.",
                    modelObjectClass.getSimpleName()));
        } else if (xmlObjectImplClasses.length == 1) {
            guessedImplClass = xmlObjectImplClasses[0];
        } else if (xmlObjectImplClasses.length > 1) {
            for (Class<? extends XmlObjectNode> xmlObjectImplClass : xmlObjectImplClasses) {
                if ((jaxbSchemaBinding.getJaxbBindingByClass(modelObjectClass) instanceof JaxbSchemaElementBinding)
                        && modelObjectClass.equals(cmd.get(xmlObjectImplClass,
                                IMPLEMENTATION_CLASS_MODELOBJECT_CLASS))) {
                    /*
                     * 1st possibility : implementation class wraps a model
                     * object based on an element (which means that there can
                     * only be one possible wrapper class) and model object
                     * class is strictly equals to metainf model object class.
                     */
                    guessedImplClass = xmlObjectImplClass;
                    break;
                } else if (cmd.has(xmlObjectImplClass,
                        IMPLEMENTATION_CLASS_CONSTANT_QNAME)
                        && qname.equals(cmd.get(xmlObjectImplClass,
                                IMPLEMENTATION_CLASS_CONSTANT_QNAME))) {
                    /*
                     * 2nd possibility : implementation class wraps a model
                     * object based on a type (which means that there can be
                     * multiple wrapper classes). Proper implementation class is
                     * chosen thanks to its metainf constant QName.
                     */
                    guessedImplClass = xmlObjectImplClass;
                    break;
                }
            }
        }
        if (guessedImplClass == null) {
            StringBuffer sb = new StringBuffer();
            for (Class<? extends XmlObjectNode> xmlObjectImplClass : xmlObjectImplClasses) {
                sb.append(xmlObjectImplClass.getSimpleName()).append(" ");
            }
            throw new UncheckedException(
                    String.format(
                            "Cannot guess unambiguously implementation class wrapping object of class '%s' ; candidates are '%s'.",
                            modelObjectClass.getSimpleName(), sb.toString()
                                    .trim()));
        }
        return wrap(xmlContext, guessedImplClass, ajo);

    }

    @Override
    public final <X extends XmlObjectNode> X create(XmlContext xmlContext,
            Class<X> xmlObjectImplClass) {
        return wrap(xmlContext, xmlObjectImplClass, null);
    }

}
