package com.ebmwebsourcing.easybox.impl;

import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectSchemaBinding;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;

final class JaxbNamespacePrefixMapperImpl extends NamespacePrefixMapper {

    private final Map<String, String> preferredPrefixes;

    public JaxbNamespacePrefixMapperImpl(XmlContext xmlContext) {
        preferredPrefixes = new HashMap<String, String>();
        for (XmlObjectBinding xob : xmlContext.getXmlObjectBindings()) {
            if (xob instanceof XmlObjectSchemaBinding) {
                XmlObjectSchemaBinding xosb = (XmlObjectSchemaBinding) xob;
                preferredPrefixes.put(xosb.getOriginatingSchemaNamespaceURI(),
                        xosb.getOriginatingSchemaPreferredNamespacePrefix());
            }
        }
    }

    @Override
    public String getPreferredPrefix(String namespaceUri, String suggestion,
            boolean requirePrefix) {
        String preferredPrefix = preferredPrefixes.get(namespaceUri);
        if (preferredPrefix != null)
            return preferredPrefix;
        return suggestion;
    }

    @Override
    public String[] getPreDeclaredNamespaceUris() {
        // TODO : here we should predeclare all prefixes found at parsing time
        // which are not in preferredPrefixes.
        return new String[] {};
    }
}
