package com.ebmwebsourcing.easybox.impl;

import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.ModelObject;

final class ModelObjectComparator {

    private ModelObjectComparator() {
    }
    
    private static boolean areJAXBElementEquals(JAXBElement<?> o1,
            JAXBElement<?> o2) {
        assert o1 != null;
        assert o2 != null;
        assert o1.getName() != null;
        assert o2.getName() != null;
        if (!o1.getName().equals(o2.getName()))
            return false;
        assert o1.getValue() != null;
        assert o2.getValue() != null;
        return o1.getValue().equals(o2.getValue());
    }

    private static boolean areJAXBObjectEquals(AbstractJaxbModelObject ajo1,
            AbstractJaxbModelObject ajo2) {
        // TODO : can be heavily optimized!
        Map<QName, Object> attributes1 = JaxbReflector
                .collectJaxbAttributes(ajo1);
        Map<QName, Object> attributes2 = JaxbReflector
                .collectJaxbAttributes(ajo2);
        if (!attributes1.equals(attributes2)) {
            return false;
        }
        ModelObject[] children1 = JaxbReflector.collectJaxbChildren(ajo1);
        ModelObject[] children2 = JaxbReflector.collectJaxbChildren(ajo2);
        if (children1.length != children2.length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            if (!areEquals(children1[i], children2[i])) {
                return false;
            }
        }
        return true;

    }

    // TODO refactor this; no need of jaxb comparator.
    static boolean areEquals(ModelObject o1, ModelObject o2) {
        if (o1 == null)
            return o2 == null;
        if (o2 == null)
            return o1 == null;
        if (!o1.getClass().isAssignableFrom(o2.getClass())
                && !o2.getClass().isAssignableFrom(o1.getClass()))
            return false;
        if (o1 instanceof JAXBElement<?>) {
            return areJAXBElementEquals((JAXBElement<?>) o1,
                    (JAXBElement<?>) o2);
        } else if (o1 instanceof AbstractJaxbModelObject) {
          return areJAXBObjectEquals((AbstractJaxbModelObject) o1,
                  (AbstractJaxbModelObject) o2);
        } else {
            return o1.equals(o2);
        }

    }

    
}
