package com.ebmwebsourcing.easybox.impl;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public final class XmlObjectDomBindingImpl implements XmlObjectBinding {

    @Override
    public String getName() {
        return "easybox-impl-dom";
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObjectNode>[] getFactorableClasses() {
        List<Class<? extends XmlObjectNode>> factorableClasses = new ArrayList<Class<? extends XmlObjectNode>>();
        factorableClasses.add(AnyXmlObjectImpl.class);    
        factorableClasses.add(XmlObjectTextImpl.class);    
        factorableClasses.add(XmlObjectAttributeImpl.class);    
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }

    @Override
    public boolean canWrap(Object obj) {
        return (obj instanceof DomModelObject) || (obj instanceof TextModelObject);
    }

    
    @SuppressWarnings("unchecked")
    @Override
    public <X extends XmlObjectNode> X wrap(XmlContext xmlContext,
            Class<X> xmlObjectImplClass, Object obj) {
        assert xmlObjectImplClass != null;
        assert xmlObjectImplClass.equals(AnyXmlObjectImpl.class) ||
               xmlObjectImplClass.equals(XmlObjectTextImpl.class);
        if (obj instanceof DomModelObject) {
            return (X) new AnyXmlObjectImpl(xmlContext, (DomModelObject) obj);
        } else if (obj instanceof TextModelObject) {
            return (X) new XmlObjectTextImpl(xmlContext, (TextModelObject) obj);
        } else {
            throw new UncheckedException(String.format(
                    "Do not know how to wrap object of class '%s'.", obj
            .getClass().getSimpleName()));
        }
    }

    @Override
    public XmlObjectNode wrap(XmlContext xmlContext, Object obj) {
        return wrap(xmlContext, AnyXmlObjectImpl.class, obj);
    }

    
    @SuppressWarnings("unchecked")
    @Override
    public <X extends XmlObjectNode> X create(XmlContext xmlContext,
            Class<X> xmlObjectImplClass) {
        assert xmlObjectImplClass != null;
        assert (xmlObjectImplClass == AnyXmlObjectImpl.class) ||
        (xmlObjectImplClass == XmlObjectTextImpl.class);
        if (xmlObjectImplClass == AnyXmlObjectImpl.class) {
            return (X) new AnyXmlObjectImpl(xmlContext, null);
        } else {
            return (X) new XmlObjectTextImpl(xmlContext, null);
        }
    }

    
    
    
}
