package com.ebmwebsourcing.easybox.impl;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

final class XmlObjectWriterImpl implements XmlObjectWriter {

    // TODO : be able to specify encoding !! (JAXB property to be set)
    
    private XmlContextImpl xmlContext;

    public XmlObjectWriterImpl(XmlContextImpl context) {
        this.xmlContext = context;
    }

    
    private Marshaller newMarshaller() {
        try {
            Marshaller marshaller = xmlContext.getJaxbContext().createMarshaller();
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", 
                        new JaxbNamespacePrefixMapperImpl(xmlContext));
            } catch( PropertyException e ) {
                throw new UncheckedException("Unrecognized JAXB property.", e);
            }

            return marshaller;
        } catch (JAXBException je) {
            throw new UncheckedException("Cannot create JAXB marshaller.", je);
        }
    } 
    
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public void writeDocument(XmlObject xmlObject, ContentHandler contentHandler)
            throws XmlObjectWriteException {
        assert xmlObject instanceof AbstractXmlObjectImpl<?>;
        assert xmlObject.getXmlObjectQName() != null;
        AbstractModelObject ajo = ((AbstractXmlObjectImpl<?>) xmlObject)
                .getModelObject();
        try {
            newMarshaller().marshal(
                    new JAXBElement(xmlObject.getXmlObjectQName(), ajo
                            .getClass(), ajo), contentHandler);
        } catch (JAXBException je) {
            throw new XmlObjectWriteException(je);
        }
    };
    
    @Override
    public void writeDocument(XmlObject xmlObject,
            java.io.OutputStream outputStream) throws XmlObjectWriteException {
        assert xmlObject instanceof AbstractXmlObjectImpl<?>;
        try {
            TransformerHandler serializer = ((SAXTransformerFactory) SAXTransformerFactory
                    .newInstance()).newTransformerHandler();
            serializer.setResult(new StreamResult(outputStream));
            writeDocument(xmlObject, serializer);
        } catch (TransformerConfigurationException e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerConfigurationException)");
        } catch (TransformerFactoryConfigurationError e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerFactoryConfigurationError)");
        }
    };

    
    @Override
    public void writeDocument(XmlObject xmlObject, Node node)
            throws XmlObjectWriteException {
        assert xmlObject instanceof AbstractXmlObjectImpl<?>;
        try {
            TransformerHandler serializer = ((SAXTransformerFactory) SAXTransformerFactory
                    .newInstance()).newTransformerHandler();
            serializer.setResult(new DOMResult(node));
            writeDocument(xmlObject, serializer);
        } catch (TransformerConfigurationException e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerConfigurationException)");
        } catch (TransformerFactoryConfigurationError e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerFactoryConfigurationError)");
        }    }
}
