package com.ebmwebsourcing.easybox.impl;

import java.net.URI;

import javax.xml.namespace.QName;

import org.w3c.dom.Node;

import com.ebmwebsourcing.easybox.api.ModelObject;

public final class AttributeModelObject extends AbstractModelObject {

    private ModelObject parent;
    private QName qname;
	private Object value;

	public AttributeModelObject(ModelObject parent, QName qname, Object value) {
	    assert value != null;
	    this.parent = parent;
	    this.qname = qname;
	    this.value = value;
	}


	public Node getDOMNode() {
	    throw new AssertionError();
	};

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AttributeModelObject other = (AttributeModelObject) obj;
		return value.equals(other.value);
	}

	@Override
	public ModelObject getNaturalParent() {
	    return parent;
	}

	@Override
	public ModelObject getAdoptiveParent() {
	    return null;
	}

	
	public ModelObject[] getChildren() {
	    return new ModelObject[0];
	}

	
	@Override
	public URI getBaseURI() {
		return parent.getBaseURI();
	}

	@Override
	public void setBaseURI(URI baseUri) {
	    throw new AssertionError();
	}

	
	@Override
	protected void setNaturalParent(ModelObject modelObject) {
	    this.parent = modelObject;
	}

	@Override
	protected void setAdoptiveParent(ModelObject modelObject) {
	    throw new UnsupportedOperationException();
	}
	
	@Override
	public ModelObject duplicate() {
	    throw new AssertionError();
	}

	
    @Override
    public <X extends ModelObject> X duplicateAs(Class<X> targetClass) {
        throw new AssertionError();
    }
    
    
    QName getQName() {
        return qname;
    }
    
    
    Object getValue() {
        return value;
    }
	
}
