package com.ebmwebsourcing.easybox.impl;

import javax.xml.bind.annotation.XmlTransient;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;

@XmlTransient
public abstract class AbstractModelObject implements ModelObject {

    @XmlTransient
    private XmlObjectNode xmlObjectNode;

    public AbstractModelObject() {
        this.xmlObjectNode = null;
    }

    protected final void setXmlObject(XmlObjectNode xmlObjectNode) {
        this.xmlObjectNode = xmlObjectNode;
    }

    protected abstract void setNaturalParent(ModelObject modelObject);

    protected abstract void setAdoptiveParent(ModelObject modelObject);

    public final XmlObjectNode getXmlObject() {
        return xmlObjectNode;
    }


    public final ModelObject getParent() {
        if (getNaturalParent() != null) {
            return getNaturalParent();
        }
        return getAdoptiveParent();
    }

}
