package com.ebmwebsourcing.easybox.impl;


import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import com.ebmwebsourcing.easybox.api.AnyXmlObject;
import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;

final class AnyXmlObjectImpl extends AbstractXmlObjectImpl<DomModelObject> implements AnyXmlObject {

	AnyXmlObjectImpl(XmlContext xmlContext, DomModelObject domModelObject) {
		super(xmlContext, domModelObject);
	}

	@Override
	public QName getXmlObjectQName() {
		Node domElement = getModelObject().getDOMNode();
		if(domElement == null) {
			return null;
		}
		if ((domElement.getLocalName() != null) &&
				(domElement.getNamespaceURI() != null)) {
			if(domElement.getPrefix() != null) {
				return new QName(domElement.getNamespaceURI(), 
						domElement.getLocalName(), 
						domElement.getPrefix());
			} else {
				return new QName(domElement.getNamespaceURI(), 
						domElement.getLocalName());
			}
		} else {
			return new QName(domElement.getNodeName());
		}        
	}

	@Override
	public void setXmlObjectQName(QName qname) {
		throw new AssertionError("Not implemented");
	}

	@Override
	public Map<QName, Object> getXmlObjectAttributes() {
	    Map<QName, Object> attributes = new HashMap<QName, Object>();
	    Element element = (Element) getModelObject().getDOMNode();
	    NamedNodeMap nnm = element.getAttributes();
	    for (int i = 0 ; i < nnm.getLength() ; ++i) {
	        Node node = nnm.item(i);
	        QName qName = (node.getNamespaceURI() != null) ? 
	                new QName(node.getNamespaceURI(), node.getLocalName()) : new QName(node.getLocalName());
	        attributes.put(qName, node.getNodeValue());
	    }
		return attributes;
	}

	@Override
	public XmlObjectNode[] getXmlObjectNaturalChildren() {
		ModelObject[] modelChildren = getModelObject().getChildren();
		XmlObjectNode[] children = new XmlObject[modelChildren.length];
		for (int i = 0 ; i < modelChildren.length ; ++i) {
			children[i] = getXmlContext().getXmlObjectFactory().wrap(modelChildren[i]);
		}
		return children;
	}

	@Override
	public XmlObjectNode[] getXmlObjectAdoptedChildren() {
		return XmlObjectNode.EMPTY_ARRAY;
	}

	@Override
	public Node getXmlObjectDOMNode() {
		return getModelObject().getDOMNode();
	}

	@Override
	protected Class<? extends DomModelObject> getCompliantModelClass() {
		return DomModelObject.class;
	}

	@Override
	protected DomModelObject createCompliantModel() {
		// TODO : create a proper DOM element instead of null...
		return new DomModelObject(null, null);
	}

	@Override
	public final String toString() {
		StringBuffer sb = new StringBuffer(super.toString());
		NodeList nodeList = getModelObject().getDOMNode().getChildNodes();
		for (int i = 0 ; i < nodeList.getLength() ; ++i) {
			Node node = nodeList.item(i);
			if (node instanceof Text) {
				sb.append("\n  # ").append(node.getNodeValue());
			}
		}
		return sb.toString();
	}
}
