package com.ebmwebsourcing.easybox.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easycommons.xml.DOMHelper;

public final class DomModelObject extends AbstractModelObject {

    private ModelObject parentModelObject;
	private final Node domElement;


	public DomModelObject(ModelObject parentModelObject, Node domElement) {
	    this.parentModelObject = parentModelObject;
		this.domElement = domElement;
	}

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((domElement == null) ? 0 : domElement.hashCode());
        return result;
    }


    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DomModelObject other = (DomModelObject) obj;
        if (domElement == null) {
            if (other.domElement != null)
                return false;
        } else if (!DOMHelper.areDOMNodeEqualRegardlessOfNamespaceBindings(
                this.domElement, other.domElement))
            return false;
        return true;
    }


	@Override
	public Node getDOMNode() {
	    return domElement;
	}
	
	
	@Override
	public ModelObject getNaturalParent() {
	    return parentModelObject;
	}

	
	public ModelObject[] getChildren() {
	    // TEMPORARY til we can create dom model objects
	     if (domElement == null) return new ModelObject[0];
        // TEMPORARY til we can create dom model objects
	    
		NodeList nodeList = domElement.getChildNodes();
		List<ModelObject> children = new ArrayList<ModelObject>();
		for (int i = 0 ; i < nodeList.getLength() ; ++i) {
			Node node = nodeList.item(i);
			if (node instanceof Element) {
				children.add(ModelObjectFactory.createModelObject(this, (Element) node));
			}
		}
		return children.toArray(new ModelObject[children.size()]);
	}

	
	@Override
	public URI getBaseURI() {
	    if (parentModelObject == null) return null;
		return parentModelObject.getBaseURI();
	}

	@Override
	public void setBaseURI(URI baseUri) {
	    throw new AssertionError();
	}

	
	@Override
	protected void setNaturalParent(ModelObject modelObject) {
		this.parentModelObject = modelObject;
	}

	@Override
	public ModelObject duplicate() {
	    throw new AssertionError();
	}

	
    @Override
    public <X extends ModelObject> X duplicateAs(Class<X> targetClass) {
        throw new AssertionError();
    }
    
    @Override
    public ModelObject getAdoptiveParent() {
        return null;
    }
	
    
    @Override
    protected void setAdoptiveParent(ModelObject modelObject) {
        throw new UnsupportedOperationException();
    }
}
